#pragma once
#include "db_driver.h"

struct ACL_DB_POOL;
class db_result;

class driver_mysql : public db_driver
{
public:
	driver_mysql(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		int dbpool_limit = 50, int dbpool_ping = 30,
		int dbpool_timeout = 60);
	virtual ~driver_mysql(void);

	/**
	 * ݿ⼰ݱݿδ򴴽µݿ⣬
	 * ڸݿϴµݱݱҲڸݱϴ
	 * µҲڣֱӷȷ
	 * @param dbname {const char*} ݿ
	 * @param tbl {const char* tbl} ݱ
	 * @param idx {const char* idx} ݱֵݱ
	 *  򴴽µĻڸѾڵ
	 * @param idx_unique {bool} ֶǷҪΨһ
	 * @param user {const char*} 򿪸ݿ˺
	 * @param pass {const char*} 򿪸ݿ˺
	 * @return {bool} Ƿɹ
	 */
	virtual  bool create(const char* dbname, const char* tbl,
			const char* idx, bool idx_unique = false,
			const char* user = NULL, const char* pass = NULL);

	/**
	 * ݿ⼰ݱݿ⡢ݱ򷵻ʧ
	 * @param dbname {const char*} ݿ
	 * @param tbl {const char* tbl} ݱ
	 * @param idx {const char*} ֶ
	 * @param user {const char*} 򿪸ݿ˺
	 * @param pass {const char*} 򿪸ݿ˺
	 * @return {bool} Ƿɹ
	 */
	virtual bool open(const char* dbname, const char*tbl, const char* idx,
			const char* user = NULL, const char* pass = NULL);

	/**
	 * ӻ޸ݣֵӦݲʱݣ޸
	 * Ϊµ
	 * @param idx_value {const char*} ֵӦ open е
	 * @param data {cost void*} ݵַ
	 * @param dlen {size_t} data ݳ
	 * @return {bool}  false ʾʧܣԭ last_error() 
	 */
	virtual bool set(const char* idx_value, const void* data, size_t dlen);

	/**
	 * ֵ
	 * @param idx_value {const char*} ֵӦ open 򿪵ֶ
	 * @return {db_result*} 洢ѯֵǿʾѯɹ
	 *  Ҫһ db_result еĺòѯ
	 *  NULL ʾҪ last_error() óԭ
	 */
	virtual db_result* get(const char* idx_value);

	/**
	 * ֵɾݣͬʱɾصֵ
	 * @param idx_value {const char*} Ӧ open еֶεֵ
	 * @return {bool}  false ʾʧܣԭ last_error() ã
	 *  ɾ affect_count() 
	 */
	virtual bool del(const char* idx_value);

	/**
	 * ڵ set/del ʱô˺ԻӰļ¼ get
	 * ûбҪô˺
	 * @return {int} ֵ >= 0 ʾӰ¼
	 */
	virtual size_t affect_count() const;

	/**
	 * ô˺ϴβĴ
	 * @return {db_error_t} 
	 */
	virtual db_error_t last_error() const;

private:
	ACL_DB_POOL* dbpool_;
};
