#pragma once
#include <stdarg.h>
#include <vector>
#include "../acl_cpp_define.hpp"
#include "../stdlib/string.hpp"
#include "../stdlib/noncopyable.hpp"
#include "../stream/socket_stream.hpp"

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_BEANSTALK_DISABLE)

struct ACL_ARGV;

namespace acl {

/**
 * Ϣ ID Ŵ 1 ʼ(μ beanstalkd  job.c Դеݣ
 *     static uint64 next_id = 1;  make_job_with_id() е
 *     if (id) {
 *         j->r.id = id;
 *         if (id >= next_id) next_id = id + 1;
 *     } else {
 *         j->r.id = next_id++;
 *     }
 * Ϣȼ pri ȡֵΧΪ 0 ~ 4,294,968,295(޷ֵ)ֵԽС
 * ȼԽߣ߼Ϊ 0 
 * ϢĬ󳤶Ϊ 65,535(޷ short ֵ)ֵ beanstalkd ָ
 * οĿ doc/ Ŀ¼µ <beanstalkЭ.pdf>
 * еڲԶӲУ֮ǰ watch  use
 * УԶЩ̣һ˵ʽ open ̣û
 * close 󣬲Ͽ beanstalkd ӣͬʱд洢
 * use  watch 
 */
class ACL_CPP_API beanstalk : public noncopyable
{
public:
	/**
	 * 캯
	 * @param addr {const char*} beanstalkd ַʽip:port/domain:port
	 * @param conn_timeout {int} ӷĳʱʱ()
	 * @param retry {bool} ӶǷԶ
	 */
	beanstalk(const char* addr, int conn_timeout, bool retry = true);
	~beanstalk();

	/////////////////////////////////////////////////////////////////////
	// ߵõĽӿ

	/**
	 * ѡõķ͹ܵ
	 * @param tube {const char*} ܵ
	 * @return {bool} Ƿɹ
	 */
	bool use(const char* tube);

	/**
	 * ѡܵȱʡзϢ
	 * @param data {const void*} ϢݵַǶ
	 * @param len {size_t} data 峤
	 * @param pri {unsigned} ȼֵԽСȼԽ
	 * @param delay {unsigned} ʾjobreadyҪȴ
	 * @param ttr {unsigned} ʾһworkerִиϢ
	 * @return {unsigned long long} ϢϢţ
	 *  ֵ > 0 ʾӳɹ == 0 ʾʧ
	 *  (鿴 beanstalkd Դ룬ԿϢŴ 1 ʼ)
	 */
	unsigned long long put(const void* data, size_t len,
		unsigned pri = 1024, unsigned delay = 0, unsigned ttr = 60);

	/**
	 * ԸʽַʽѡܵȱʡзϢ
	 * @param pri {unsigned} ȼֵԽСȼԽ
	 * @param delay {unsigned} ʾjobreadyҪȴ
	 * @param ttr {unsigned} ʾһworkerִиϢ
	 * @param fmt {const char*} ʽַ
	 * @return {unsigned long long} ϢϢţ
	 *  ֵ > 0 ʾӳɹ == 0 ʾʧ
	 *  (鿴 beanstalkd Դ룬ԿϢŴ 1 ʼ)
	 */
	unsigned long long format_put(unsigned pri, unsigned delay, unsigned ttr,
		const char* fmt, ...) ACL_CPP_PRINTF(5, 6);

	unsigned long long vformat_put(const char* fmt, va_list ap,
		unsigned pri = 1024, unsigned delay = 0, unsigned ttr = 60);

	/**
	 * ԸʽַʽѡܵȱʡзϢе
	 *  pri, delay, ttr Ĭֵ
	 * @param fmt {const char*} ʽַ
	 * @return {unsigned long long} ϢϢţ
	 *  ֵ > 0 ʾӳɹ == 0 ʾʧ
	 *  (鿴 beanstalkd Դ룬ԿϢŴ 1 ʼ)
	 */
	unsigned long long format_put(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);

	/////////////////////////////////////////////////////////////////////
	// ߵõĽӿ

	/**
	 * ѡȡϢĹܵعбУ
	 * ñʹȱʡĹܵ(default)
	 * @param tube {const char*} Ϣܵ
	 * @return {unsigned} ֵΪעϢܵ, ֵ > 0 ʾɹ
	 */
	unsigned watch(const char* tube);

	/**
	 * ȡע(watch)һϢĹܵ(tube)
	 * @param tube {const char*} Ϣܵ
	 * @return {unsigned} ֵΪʣϢעܵ, ֵ > 0 ʾ
	 *  ɹ(ҪעһȱʡϢܵȷ¸÷ֵΪ 1)
	 *  ֵΪ 0 ˵Ĺܵδעȡעʧ
	 */
	unsigned ignore(const char* tube);

	/**
	 * ȡעеĽϢĹܵ
	 * @return {unsigned} ֵΪʣϢעܵ, ֵ > 0 ʾ
	 *  ɹ(ҪעһȱʡϢܵȷ¸÷ֵΪ 1)
	 *   0 ʾȡעʧ
	 */
	unsigned ignore_all();

	/**
	 * ϢܵлȡһϢɾϢ
	 * ȴʱΪ -1 ԶȴϢ
	 * @param buf {string&} 洢õһϢڲոû
	 * @param timeout {int} ȴзϢĳʱֵΪ -1
	 *  ʱڵȴ > 0 ʱڸʱûϢ򷵻أ
	 *   == 0 ʱһϢ򷵻سʱ
	 * @return {unsigned long long} ȡõϢţֵ > 0
	 *  ʾȷȡһϢ˵ʱûϢãе
	 *   0 ʱ get_error() õΪ TIMED_OUT ʾ
	 *  ʱˣΪ DEADLINE_SOON ʱʾϢѾȡڹ涨 ttr
	 *  (ʱ) ûб delete_id
	 */
	unsigned long long reserve(string& buf, int timeout = -1);

	/**
	 * Ӷзɾָ ID ŵϢ
	 * @param id {unsigned long long} Ϣ
	 * @return {bool} Ƿɹɾ
	 */
	bool delete_id(unsigned long long id);

	/**
	 * һѾȡϢ·Żready(job״̬Ϊ "ready")
	 * øϢԱӻ
	 * @param id {unsigned long long} Ϣ
	 * @param pri {unsigned} ȼ
	 * @param delay {unsigned} ڸϢready֮ǰҪȴ
	 * @return {bool} Ƿɹ
	 */
	bool release(unsigned long long id, unsigned pri = 1024,
		unsigned delay = 0);

	/**
	 * һϢ״̬Ϊ "buried", Buried ϢһFIFOУ
	 * ڿͻ˵kick֮ǰЩϢᱻ˴
	 * @param id {unsigned long long} Ϣ
	 * @param pri {unsigned int} ȼ
	 * @return {bool} Ƿɹ
	 */
	bool bury(unsigned long long id, unsigned pri = 1024);

	/**
	 * һworkerһϢȡִеʱ䡣ЩҪ
	 * ʱɵϢǷǳõģͬʱҲTTRƽһϢ
	 * һ޷ɹworkerߡһworkerͨ
	 * ִиjob (磺յDEADLINE_SOONǿԷ)
	 * @param id {unsigned long long} Ϣ
	 * @return {bool} Ƿɹ
	 */
	bool touch(unsigned long long id);

	/////////////////////////////////////////////////////////////////////
	// ӿ

	/**
	 *  beanstalkd ͨ²Ҫʾصøú
	 * ԶҪԶñ
	 * @return {bool}  ɹ
	 */
	bool open();

	/**
	 * ʾر beanstalkd ӣʵʱ᳢Եùرչ̣
	 * ñڲ tube_used_  tubes_watched_ ᱻͷ
	 */
	void close();

	/**
	 * ʾ֪ͨ beanstalkd ˳(յر)
	 */
	void quit();

	/**
	 * ȡϢָϢŵ
	 * @param buf {string&} Ϣ洢Ϣڲոû
	 * @param id {unsigned long long} ָϢ
	 * @return {unsigned long long} ȡõ ready ״̬Ϣţ
	 *  ֵ > 0 ˵ȡһϢʾûϢ
	 */
	unsigned long long peek(string& buf, unsigned long long id);

	/**
	 * õǰע (watch) ܵеһ ready ״̬Ϣ
	 * ϢҲ
	 * @param buf {string&} Ϣ洢Ϣڲոû
	 * @return {unsigned long long} ȡõ ready ״̬Ϣţ
	 *  ֵ > 0 ˵ȡһϢʾûϢ
	 */
	unsigned long long peek_ready(string& buf);

	/**
	 * õǰע (watch) ܵеһ delayed ״̬Ϣ
	 * ϢҲ
	 * @param buf {string&} Ϣ洢Ϣڲոû
	 * @return {unsigned long long} ȡõ delayed ״̬Ϣţ
	 *  ֵ > 0 ˵ȡһϢʾûϢ
	 */
	unsigned long long peek_delayed(string& buf);

	/**
	 * õǰע (watch) ܵеһ buried ״̬Ϣ
	 * ϢҲ
	 * @param buf {string&} Ϣ洢Ϣڲոû
	 * @return {unsigned long long} ȡõ buried ״̬Ϣţ
	 *  ֵ > 0 ˵ȡһϢʾûϢ
	 */
	unsigned long long peek_buried(string& buf);

	/**
	 * ֻԵǰʹõtubeִУ buried
	 *  delayed ״̬Ϣƶ ready 
	 * @param n {unsigned} ʾÿ kick Ϣޣ
	 *  ˽ kick Ϣ
	 * @return {int} ʾkickϢĿ -1 ʾ
	 */
	int  kick(unsigned n);

	/**
	 * ÿͻǰʹõϢܵ
	 * @param buf {string&} 洢ǰʹõϢܵڲոû
	 * @return {bool} Ƿɹ
	 */
	bool list_tube_used(string&buf);

	/**
	 * ѾڵϢܵ(tube)б
	 * @param buf {string&} 洢ڲոû
	 * @return {bool} Ƿɹ
	 */
	bool list_tubes(string& buf);

	/**
	 * õǰע(watch)Ϣܵļ
	 * @param buf {string&} 洢ڲոû
	 * @return {bool} Ƿɹ
	 */
	bool list_tubes_watched(string& buf);

	/**
	 * ʱָͣϢܵ(tube)лȡϢ
	 * @param tube {const char*} Ϣܵ
	 * @param delay {unsigned} ָʱ
	 * @return {bool} Ƿɹ
	 */
	bool pause_tube(const char* tube, unsigned delay);

	/////////////////////////////////////////////////////////////////////
	// ӿ
	const char* get_error() const
	{
		return errbuf_.c_str();
	}

	socket_stream& get_conn()
	{
		return conn_;
	}

	/**
	 * ع캯 beanstalkd ķַʽip:port
	 * @return {const char*} Զطǿյ beanstalkd ַ
	 */
	const char* get_addr() const
	{
		return addr_;
	}

private:
	char* addr_;
	int   timeout_;
	bool  retry_;
	string  errbuf_;
	char* tube_used_;
	std::vector<char*> tubes_watched_;
	socket_stream conn_;
	unsigned long long peek_fmt(string& buf, const char* fmt, ...)
		ACL_CPP_PRINTF(3, 4);
	bool list_tubes_fmt(string& buf, const char* fmt, ...)
		ACL_CPP_PRINTF(3, 4);

	unsigned ignore_one(const char* tube);
	bool beanstalk_open();
	bool beanstalk_use();
	unsigned beanstalk_watch(const char* tube);
	ACL_ARGV* beanstalk_request(const string& cmdline,
		const void* data = NULL, size_t len = 0);
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_BEANSTALK_DISABLE)
