#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"
#include <map>

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_BEANSTALK_DISABLE)

namespace acl {

class beanstalk;
class locker;

/**
 * beanstalk ͻӳأͬʱӲͬ beanstalkd 
 * ÿ beanstalkd жӣڲԶƣ
 * ûӦпӳص
 */
class ACL_CPP_API beanstalk_pool : public noncopyable
{
public:
	beanstalk_pool();
	~beanstalk_pool();

	/**
	 * ӳȡһ beanstalkd Ŀͻ
	 * @param addr {const char*} beanstalkd ַ(domain:port)
	 * @param clean_watch {bool} ȡӶǷԶȡе
	 *  ѹע
	 * @param conn_timeout {int}  beanstalkd ĳʱʱ
	 * @return {beanstalk*} طǿձʾʾ
	 */
	beanstalk* peek(const char* addr, bool clean_watch = true,
		int conn_timeout = 60);

	/**
	 * õ beanstalkd ӷŻصӳ
	 * @param client {beanstalk*} beanstalkd ͻ
	 * @param clean_watch {bool} ǷȡѾעĶ
	 * @param keep {bool} Ϊ true  client Żӳأ
	 *  ͷŸ
	 */
	void put(beanstalk* client, bool clean_watch = true,
		bool keep = true);
private:
	locker* lock_;
	typedef std::multimap<string, beanstalk*> bspool;
	typedef bspool::const_iterator pool_cit;
	typedef bspool::iterator pool_it;
	typedef std::pair<pool_it, pool_it> pool_range;

	bspool pool_;
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_BEANSTALK_DISABLE)
