#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/string.hpp"
#include "../stdlib/locker.hpp"
#include "../stdlib/noncopyable.hpp"
#include <vector>
#include <map>

struct ACL_EVENT;

namespace acl
{

class connect_pool;
class connect_monitor;

// ڲʹݽṹ
struct conns_pools {
	std::vector<connect_pool*> pools;
	size_t  check_next;			// Ӽʱļ±
	size_t  conns_next;			// һҪʵĵ±ֵ
	conns_pools(void)
	{
		check_next = 0;
		conns_next = 0;
	}
};

struct conn_config {
	string addr;
	size_t count;
	int    conn_timeout;
	int    rw_timeout;

	conn_config(void) {
		count        = 0;
		conn_timeout = 5;
		rw_timeout   = 5;
	}
};

/**
 * connect pool лȡӳصȹ
 */
class ACL_CPP_API connect_manager : public noncopyable
{
public:
	connect_manager(void);
	virtual ~connect_manager(void);

	/**
	 * Ƿӳ߳Զ󶨣ҪЭ̻УڲȱʡֵΪ false
	 * ÷ڱ󴴽ܵһ
	 * @param yes {bool}
	 */
	void bind_thread(bool yes);

	/**
	 * ʼзӳأú set ÿӳ
	 * @param default_addr {const char*} ȱʡķַǿգ
	 *  ڲѯʱʹô˷
	 * @param addr_list {const char*} збΪ
	 *  ʽ: IP:PORT:COUNT;IP:PORT:COUNT;IP:PORT;IP:PORT ...
	 *      IP:PORT:COUNT,IP:PORT:COUNT,IP:PORT;IP:PORT ...
	 *  磺127.0.0.1:7777:50;192.168.1.1:7777:10;127.0.0.1:7778
	 * @param count {size_t}  addr_list зָĳû
	 *  COUNT ϢʱôֵֵΪ 0 ʱ
	 * @param conn_timeout {int} ʱ()
	 * @param rw_timeout {int}  IO ʱʱ()
	 *  עdefault_addr  addr_list ͬʱΪ
	 */
	void init(const char* default_addr, const char* addr_list,
		size_t count, int conn_timeout = 30, int rw_timeout = 30);

	/**
	* ӷĿͻӳأúڳʱãڲԶ
	 * @param addr {const char*} ַʽip:port
	 *  ע⣺ñʱÿνһַѭñ
	 * @param count {size_t} ӳ, ֵΪ 0
	 *  ӳص
	 * @param conn_timeout {int} ʱ()
	 * @param rw_timeout {int}  IO ʱʱ()
	 */
	void set(const char* addr, size_t count,
		int conn_timeout = 30, int rw_timeout = 30);

	/**
	 * ַָȡõַӦӳö
	 * @param addr {const char*} Ŀӳصַ
	 * @param use_first {bool} Ŀַö󲻴ڣǷʹ
	 *  һַö
	 * @return {const conn_config*}  NULL ʾ
	 */
	const conn_config* get_config(const char* addr, bool use_first = false);

	/**
	 * ӳʧܺԵʱʱ룩úڳʱ
	 * ãڲԶ
	 * @param n {int} ֵ <= 0 ʱӳس
	 */
	void set_retry_inter(int n);

	/**
	 * ӳпӵĿ
	 * @param ttl {time_t} ӵڣֵ < 0 ʾ
	 *  ڣ== 0 ʱʾ̹ڣ> 0 ʾиʱκ󽫱ͷ
	 */
	void set_idle_ttl(time_t ttl);

	/**
	 * ԶӵʱȱʡֵΪ 30 
	 * @param n {int} ʱ
	 */
	void set_check_inter(int n);

	/**
	 * ӳؼȺɾĳַӳأúڳй
	 * ãΪڲԶ
	 * @param addr {const char*} ַ(ip:port)
	 */
	void remove(const char* addr);

	/**
	 * ݷ˵ַø÷ӳ
	 * @param addr {const char*} redis ַ(ip:port)
	 * @param exclusive {bool} ǷҪӳ飬Ҫ̬
	 *  ӳؼȺʱֵӦΪ true
	 * @param restore {bool} ÷㱻ΪʱòǷ
	 *  Զָ֮Ϊ״̬
	 * @return {connect_pool*} ؿձʾûд˷
	 */
	connect_pool* get(const char* addr, bool exclusive = true,
		bool restore = false);

	/**
	 * ӳؼȺлһӳأúѭʽӳؼлȡ
	 * һ˷ӳأӶ֤ȫľԣúڲԶ
	 * ӳعм
	 * ⣬úΪӿڣʵԼѭʽ
	 * @return {connect_pool*} һӳأָԶǿ
	 */
	virtual connect_pool* peek(void);

	/**
	 * ӳؼȺлһӳأúùϣλʽӼлȡһ
	 * ˷ӳأش麯ԼļȺȡʽ
	 * 麯ڲȱʡ CRC32 Ĺϣ㷨
	 * @param key {const char*} ֵֵַΪ NULLڲ
	 *  Զлѭʽ
	 * @param exclusive {bool} ǷҪӳ飬Ҫ̬
	 *  ӳؼȺʱֵӦΪ true
	 * @return {connect_pool*} һõӳأָԶǿ
	 */
	virtual connect_pool* peek(const char* key, bool exclusive = true);

	/**
	 * û peek ʱԵô˺ӳع̼
	 */
	void lock(void);

	/**
	 * û peek ʱԵô˺ӳع̼
	 */
	void unlock(void);

	/**
	 * еķӳأӳаȱʡķӳ
	 * @return {std::vector<connect_pool*>&}
	 */
	std::vector<connect_pool*>& get_pools(void);

	/**
	 * ӳеĿӣڵͷŵ
	 * @param step {size_t} ÿμӳصĸ
	 * @param left {size_t*} ǿʱ洢ʣӸܺ
	 * @return {size_t} ͷŵĿ
	 */
	size_t check_idle(size_t step, size_t* left = NULL);

	/**
	 * ӳؼӳضĸ
	 * @return {size_t}
	 */
	size_t size(void) const;

	/**
	 * ȱʡķӳ
	 * @return {connect_pool*}  init  default_addr Ϊʱ
	 *  ú NULL
	 */
	connect_pool* get_default_pool(void)
	{
		return default_pool_;
	}

	/**
	 * ӡǰ redis ӳصķ
	 */
	void statistics(void);

	/**
	 * ̨̼߳ӳ״̬
	 * @param monitor {connect_monitor*} Ӽ
	 * @return {bool} ǷӼ false ˵ǰ
	 *  еӼٴʱҪȵ stop_monitor
	 */
	bool start_monitor(connect_monitor* monitor);

	/**
	 * ֹ̨ͣ߳
	 * @param graceful {bool} Ƿڹرռ߳ʱҪȴеļ
	 *  رպŷأӳؼȺΪ̿ռڲηͷʱ
	 *  ֵΪ false Ӷʹ߳̿˳Ӧõȴм
	 *  ӹرպʹ߳˳
	 * @return {connect_monitor*}  start_monitor õļͬʱ
	 *  ڲ monitor_ ԱԶ NULL
	 */
	connect_monitor* stop_monitor(bool graceful = true);

	/**
	 * ĳӳطĴ״̬ڲԶ
	 * @param addr {const char*} ַʽip:port
	 * @param alive {bool} ÷Ƿ
	 */
	void set_pools_status(const char* addr, bool alive);

protected:
	/**
	 * 麯ʵִ˺ӳض
	 * @param addr {const char*} ַʽip:port
	 * @param count {size_t} ӳصĴСƣΪ 0 ʱӳû
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 * @return {connect_pool*} شӳض
	 */
	virtual connect_pool* create_pool(const char* addr,
		size_t count, size_t idx) = 0;

protected:
	typedef std::vector<connect_pool*> pools_t;
	typedef pools_t::iterator          pools_it;
	typedef pools_t::const_iterator    pools_cit;

	typedef std::map<unsigned long, conns_pools*> manager_t;
	typedef manager_t::iterator                   manager_it;
	typedef manager_t::const_iterator             manager_cit;

	bool thread_binding_;			// Э̻ÿ̰߳
	string default_addr_;			// ȱʡķַ
	connect_pool* default_pool_;		// ȱʡķӳ

	std::map<string, conn_config> addrs_;	// еķ˵ַ
	manager_t  manager_;

	locker lock_;				//  pools_ ʱĻ
	int  stat_inter_;			// ͳƷĶʱ
	int  retry_inter_;			// ӳʧܺԵʱ
	time_t idle_ttl_;			// ӵ
	int  check_inter_;			// ӵʱ
	connect_monitor* monitor_;		// ̨߳̾

	// óȱʡ֮ķȺ
	void set_service_list(const char* addr_list, int count,
		int conn_timeout, int rw_timeout);
	conns_pools& get_pools_by_id(unsigned long id);
	connect_pool* create_pool(const conn_config& cf, size_t idx);
	void create_pools_for(pools_t& pools);

	void remove(pools_t& pools, const char* addr);
	void set_status(pools_t& pools, const char* addr, bool alive);

	unsigned long get_id(void) const;
	void get_key(const char* addr, string& key);
	void get_addr(const char* key, string& addr);
	connect_pool* add_pool(const char* addr);

	// ֲ߳̾ʼʱĻص
	static void thread_oninit(void);
	// ߳˳ǰҪص˷ͷڲֲ߳̾
	static void thread_onexit(void* ctx);
};

} // namespace acl
