#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/thread.hpp"
#include "../stream/aio_handle.hpp"
#include <vector>

namespace acl
{

class aio_handle;
class check_client;
class connect_manager;
class rpc_service;
class socket_stream;
class aio_socket_stream;

class ACL_CPP_API connect_monitor : public thread
{
public:
	/**
	 * 캯
	 * @param manager {connect_manager&}
	 */
	connect_monitor(connect_manager& manager);

	virtual ~connect_monitor();

	/**
	 * ϣʽʱҪȵñ
	 * acl::rpc_service ӿڴڳʼʱñ
	 * ÷ʽ IO 
	 * @param max_threads {int} rpc_service ̳߳е߳
	 * @param addr {const char*} ϣ rpc_service ıַ
	 *  ΪĻصַ UNIX ƽ̨ʹ׽ӿڵַ
	 * @return {connect_monitor&}
	 */
	connect_monitor& open_rpc_service(int max_threads,
		const char* addr = NULL);

	/**
	 * üⶨʱʱ
	 * @param n {int} ʱ룩
	 * @return {connect_mointor&}
	 */
	connect_monitor& set_check_inter(int n);

	/**
	 * ӱĳʱʱ
	 * @param n {int} ʱʱ䣨룩
	 * @return {connect_monitor&}
	 */
	connect_monitor& set_conn_timeout(int n);

	/**
	 * ֹͣ߳
	 * @param graceful {bool} Ƿعرռ̣Ϊ true
	 *  еļӹرպ̲߳ŷأֱӼ߳
	 *  ֱӷأܻһЩڼδͷšˣ
	 *  ӳؼȺǽȫֵģԽ˲Ϊ false
	 *  ӳؼȺйҪδͷţӦΪ true
	 */
	void stop(bool graceful);

	/**
	 *  connect_manager ö
	 * @return {connect_manager&}
	 */
	connect_manager& get_manager() const
	{
		return manager_;
	}

	/**
	 * 麯رһжϸǷǴģûص
	 * пռΪǰ̵߳пռ䣬ڸûصв
	 * ̣򽫻߳
	 * @param checker {check_client&} ӵļ󣬿ͨ
	 *  check_client еķ£
	 *  1) get_conn ÷Ӿ
	 *  2) get_addr ÷˵ַ
	 *  3) set_alive Ƿ
	 *  4) close ر
	 */
	virtual void nio_check(check_client& checker, aio_socket_stream& conn);

	/**
	 * ͬ IO 麯ú̳߳صĳ߳̿ռУ
	 * رԼʵӦõӴ״̬ڱ
	 * IO 
	 * @param checker {check_client&} ӵļ
	 *  check_client õķ£
	 *  1) get_addr ÷˵ַ
	 *  2) set_alive Ƿ
	 *  check_client нֹõķ£
	 *  1) get_conn ÷Ӿ
	 *  2) close ر
	 */
	virtual void sio_check(check_client& checker, socket_stream& conn);

	/**
	 * ӳɹʱĻصʵֱ
	 * @param cost {double} ӷ󵽳ʱʱ룩
	 */
	virtual void on_connected(const check_client&, double cost)
	{
		(void) cost;
	}

	/**
	 * ӳʱʱĻصʵֱ
	 * @param addr {const char*} ķַʽ: ip:port
	 * @param cost {double} ӷ󵽳ʱʱ룩
	 */
	virtual void on_timeout(const char* addr, double cost)
	{
		(void) addr;
		(void) cost;
	}

	/**
	 * ӷʱܾʱĻصʵֱ
	 * @param addr {const char*} ķַʽ: ip:port
	 * @param cost {double} ӷ󵽱Ͽʱ룩
	 */
	virtual void on_refused(const char* addr, double cost)
	{
		(void) addr;
		(void) cost;
	}

public:
	// Ȼĺ public ģֻڲʹ
	/**
	 * ˽Ӻô˺
	 * @param checker {check_client&}
	 */
	void on_open(check_client& checker);

protected:
	// ി麯
	virtual void* run();

private:
	bool stop_;
	bool stop_graceful_;
	aio_handle handle_;			// ̵̨߳ķ
	connect_manager& manager_;		// ӳؼϹ
	int   check_inter_;			// ӳ״̬ʱ()
	int   conn_timeout_;			// ӷĳʱʱ
	rpc_service* rpc_service_;		// 첽 RPC ͨŷ
};

} // namespace acl
