#pragma once
#include "../stdlib/noncopyable.hpp"

namespace acl
{

class tcp_manager;
class tcp_pool;
class string;

/**
 * װ tcp_manager ࣬Զ̬Ŀ˵ַͬʱ̬
 * ÿһ˵ӳ
 */
class ACL_CPP_API tcp_ipc : public noncopyable
{
public:
	tcp_ipc(void);
	~tcp_ipc(void);

	/**
	 * ÿӳص
	 * @param max {int} ÿӳصƣ <= 0 ʱ
	 * @return {tcp_ipc&}
	 */
	tcp_ipc& set_limit(int max);

	/**
	 * ӳÿ˿ʱ䣬ӿʱ䳬ֵʱر
	 * @param ttl {int} ӵʱʱ
	 * @return {tcp_ipc&}
	 */
	tcp_ipc& set_idle(int ttl);

	/**
	 * ÿӵӳʱʱ
	 * @param conn_timeout {int} ӳʱʱ䣨룩
	 * @return {tcp_ipc&}
	 */
	tcp_ipc& set_conn_timeout(int conn_timeout);

	/**
	 * ÿӵдʱʱ
	 * @param timeout {int} дʱʱ䣨룩
	 * @return {tcp_ipc&}
	 */
	tcp_ipc& set_rw_timeout(int timeout);

	/**
	 *  TCP 
	 * @return {tcp_manager&}
	 */
	tcp_manager& get_manager(void) const;

	/**
	 * ԵñʾһַֻеַʱŻ
	 * @param addr {const char*} ַʽIP:PORT
	 * @return {tcp_ipc&}
	 */
	tcp_ipc& add_addr(const char* addr);

	/**
	 * ݷַɾָӳض󣬵ӳضڱʱö
	 * ᱻɾǲӳɾʽһӱ黹ӳض
	 * Żᱻɾ
	 * @param addr {const char*} ַʽIP:PORT
	 * @return {tcp_ipc&}
	 */
	tcp_ipc& del_addr(const char* addr);

	/**
	 * ָķַǷɹ
	 * @param addr {const char*} ַʽIP:PORT
	 * @return {bool}
	 */
	bool addr_exist(const char* addr);

	/**
	 * õǰеķַ
	 * @param addrs {std::vector<string>&} 洢
	 */
	void get_addrs(std::vector<string>& addrs);

	/**
	 * ָȵݰ
	 * @param addr {const char*} ָĿַ
	 * @param data {const void*} Ҫ͵ݰַ
	 * @param len {unsigned int} ݳ
	 * @param out {string*} ö NULL ʱҪӷȡӦݣ
	 *  ӦڸûУöΪ NULLʾȡ
	 *  Ӧ
	 * @return {bool} Ƿɹ
	 */
	bool send(const char* addr, const void* data, unsigned int len,
		string* out = NULL);

	/**
	 * зݰ
	 * @param data {const void*} Ҫ͵ݰַ
	 * @param len {unsigned int} ݳ
	 * @param exclusive {bool} ͹㲥ʱǷ߳Էֹ߳
	 *  ڲӳԴ
	 * @param check_result {bool} ǷӦ֤յ
	 * @param nerr {unsigned *}  NULL ʱʧܵķĸ
	 * @return {size_t} ط͵ķ
	 */
	size_t broadcast(const void* data, unsigned int len,
		bool exclusive = true, bool check_result = false,
		unsigned* nerr = NULL);

private:
	tcp_manager* manager_;
	int max_;
	int ttl_;
	int conn_timeout_;
	int rw_timeout_;

	bool send(tcp_pool&, const void*, unsigned int, string*);
};

} // namespace acl
