#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/string.hpp"
#include "../db/db_handle.hpp"

#if !defined(ACL_DB_DISABLE)

typedef struct sqlite3 sqlite3;
typedef struct sqlite3_stmt sqlite3_stmt;

namespace acl {

class charset_conv;
class sqlite_cursor;

class ACL_CPP_API db_sqlite : public db_handle
{
public:
	/**
	 * 캯
	 * @param charset {const char*} ַ(gbk, utf-8, ...)
	 */
	db_sqlite(const char* dbfile, const char* charset = "utf-8");
	~db_sqlite(void);

	/**
	 * صǰ sqlite İ汾Ϣ
	 * @return {const char*}
	 */
	const char* version(void) const;

	/**
	 * ݿ򿪺ͨ˺ݿĲã
	 * õҪϸѭ sqlite ѡҪ
	 * @param pragma {const char*} ѡݣʽΪ
	 *  PRAGMA xxx=xxx
	 *  磺PRAGMA synchronous = NORMAL
	 * @return {bool} ݿǷɹ
	 */
	bool set_conf(const char* pragma);

	/**
	 * ݿ򿪵ô˺ѡ
	 * @param pragma {const char*} ѡݣʽΪ
	 *  PRAGMA xxx
	 *  磺PRAGMA synchronous
	 * @param out {string&} ֵǿ洢
	 * @return {const char*} Ϊ˵òڻݿδ
	 */
	const char* get_conf(const char* pragma, string& out);

	/**
	 * ݿ򿪵ݿѡ
	 * @param pragma {const char*} ָѡòΪգ
	 *  еѡʽΪPRAGMA xxx磺PRAGMA synchronous
	 */
	void show_conf(const char* pragma = NULL);

	/**
	 * ݿ򿪺еӰļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	int affect_total_count(void) const;

	/**
	 * ֱӻ sqlite ľ NULL ʾ sqlite ûд
	 * ʱڲԶر sqlite
	 * @return {sqlite3*}
	 */
	sqlite3* get_conn(void) const
	{
		return db_;
	}

	/**
	 * ׼α
	 * @param cursor {sqlite_cursor&}
	 * @return {bool}
	 */
	bool prepare(sqlite_cursor& cursor);

	/**
	 * ִһǲѯ̣򽫲ѯĲ
	 * @param cursor {sqlite_cursor&}
	 * @return {bool}
	 */
	bool next(sqlite_cursor& cursor, bool* done);

	/********************************************************************/
	/*            ΪһЩ sqlite3 ˽нӿ                         */
	/********************************************************************/

	/**
	 * zSqlʼΪ prepared statement
	 * @param zSql {const char*} utf-8sql
	 * @param nByte {int} zSqlֽڳ
	 * @param ppStmt {sqlite3_stmt**} OUT: prepared statement
	 * @param pzTail {const char**} OUT: ָzSqlδʹòֵָ
	 * @return {int} ɹ SQLITE_OK򷵻ӦĴ
	 */
	int sqlite3_prepare_v2(const char *zSql,
		int nByte, sqlite3_stmt **ppStmt, const char **pzTail);

	/**
	 *  prepared statement
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @return {int}  SQLITE_BUSY, SQLITE_DONE, SQLITE_ROW,
	 *          SQLITE_ERROR,  SQLITE_MISUSE
	 */
	int sqlite3_step(sqlite3_stmt *stmt);

	/**
	 * prepared statementΪʼ״̬
	 * @param pStmt {sqlite3_stmt*} prepared statement
	 * @return {int} SQLITE_ROW, SQLITE_DONE  SQLITE_OK
	 */
	int sqlite3_reset(sqlite3_stmt *pStmt);

	/**
	 * ͷ prepared statement Դ
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @return {int} SQLITE_OK 
	 */
	int sqlite3_finalize(sqlite3_stmt *stmt);

	/**
	 * 󶨶
	 * @param stmt {sqlite3*} prepared statement
	 * @param iCol {int} 󶨵sqlеĲ
	 * @param value {const void*} 󶨵sqlеĲֵ
	 * @param n {int} ֽڳ
	 * @param destory {void(*)(void*)} 
	 * @return {int} ɹ SQLITE_OK򷵻ӦĴ
	 */
	int sqlite3_bind_blob(sqlite3_stmt *stmt, int iCol,
		const void *value, int n, void(*destory)(void*));

	/**
	 * int
	 * @param stmt {sqlite3*} prepared statement
	 * @param iCol {int} 󶨵sqlеĲ
	 * @param value {int} 󶨵sqlеĲֵ
	 * @return {int} ɹ SQLITE_OK򷵻ӦĴ
	 */
	int sqlite3_bind_int(sqlite3_stmt *stmt, int iCol, int value);

	/**
	 * int64
	 * @param stmt {sqlite3*} prepared statement
	 * @param iCol {int} 󶨵sqlеĲ
	 * @param value {long long int} 󶨵sqlеĲֵ
	 * @return {int} ɹ SQLITE_OK򷵻ӦĴ
	 */
	int sqlite3_bind_int64(sqlite3_stmt* stmt, int iCol, long long int value);

	/**
	 * text
	 * @param stmt {sqlite3*} prepared statement
	 * @param iCol {int} 󶨵sqlеĲ
	 * @param value {const void*} 󶨵sqlеĲֵ
	 * @param n {int} ֽڳ
	 * @param destory {void(*)(void*)} 
	 * @return {int} ɹ SQLITE_OK򷵻ӦĴ
	 */
	int sqlite3_bind_text(sqlite3_stmt *stmt, int iCol,
		const char *value, int n, void(*destory)(void*));

	/**
	 *  prepared statement 
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @return {int} 
	 */
	int sqlite3_column_count(sqlite3_stmt *stmt);

	/**
	 * زѯĶӦеĶƽϢ
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @param iCol {int} 
	 * @return {const void*} ָ
	 */
	const void *sqlite3_column_blob(sqlite3_stmt *stmt, int iCol);

	/**
	 * زѯĶӦеintϢ
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @param iCol {int} 
	 * @return {int} 
	 */
	int sqlite3_column_int(sqlite3_stmt *stmt, int iCol);

	/**
	 * زѯĶӦеint64Ϣ
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @param iCol {int} 
	 * @return {long long int} 
	 */
	long long int sqlite3_column_int64(sqlite3_stmt *stmt, int iCol);

	/**
	 * زѯĶӦе utf-8 text Ϣ
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @param iCol {int} 
	 * @return {const unsigned char *} ָ
	 */
	const unsigned char *sqlite3_column_text(sqlite3_stmt *stmt, int iCol);

	/**
	 * زѯĶӦеĽϢֽڳ
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @param iCol {int} 
	 * @return {const unsigned char *} ָ
	 */
	int sqlite3_column_bytes(sqlite3_stmt *stmt, int iCol);

	/**
	 * selectضе
	 * @param stmt {sqlite3_stmt*} prepared statement
	 * @param iCol {int} 
	 * @return {const char*} 
	 */
	const char *sqlite3_column_name(sqlite3_stmt *stmt, int iCol);

	/**
	 * ִеsql
	 * @param sql {const char*} ִеsql
	 * @param callback {int (*)(void*,int,char**,char**)} callback
	 * @param arg {void*}callbackĵһ
	 * @param errmsg {char**} Ϣ
	 * @return {int} SQLITE_OK 
	 */
	int sqlite3_exec(const char *sql,
		int(*callback)(void*,int,char**,char**), void *arg, char **errmsg);

	/**
	 * Ϊͷ errmsg ӵĽӿ
	 * @param ptr {void*} ͷָ
	 */
	void sqlite3_free(void* ptr);

	/********************************************************************/
	/*            Ϊ db_handle ӿ                         */
	/********************************************************************/

	/**
	 * @override
	 */
	const char* dbtype(void) const;

	/**
	 * @override
	 */
	int get_errno(void) const;

	/**
	 * @override
	 */
	const char* get_error(void) const;

	/**
	 * @override
	 */
	bool dbopen(const char* charset = NULL);

	/**
	 * @override
	 */
	bool is_opened(void) const;

	/**
	 * @override
	 */
	bool close(void);

	/**
	 * @override
	 */
	bool tbl_exists(const char* tbl_name);

	/**
	 * @override
	 */
	bool sql_select(const char* sql, db_rows* result = NULL);

	/**
	 * @override
	 */
	bool sql_update(const char* sql);

	/**
	 * @override
	 */
	int affect_count(void) const;

	/**
	 * @override
	 */
	bool begin_transaction(void);

	/**
	 * @override
	 */
	bool commit(void);

	/**
	 * @override
	 */
	bool set_busy_timeout(int nMillisecs);


private:
	// sqlite 
	sqlite3* db_;

	// ݴ洢ļ
	string dbfile_;

	// ַת
	charset_conv* conv_;

	// ַ
	string charset_;

	// ִSQLѯĺ
	bool exec_sql(const char* sql, db_rows* result = NULL);
};

} // namespace acl

#endif // !defined(ACL_DB_DISABLE)
