#pragma once
#include "../acl_cpp_define.hpp"

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_DB_DISABLE)

namespace acl {

class ACL_CPP_API pgsql_conf
{
public:
	/**
	 * 캯
	 * @param dbaddr {const char*} ַַʽΪip:port
	 *  unix_domain_pathΪ unix ׽ӿʱӦΪ unix ׽ӿļ
	 *  Ŀ¼Ҳļ postgresql ڼ unix ׽ӿ
	 *  ļΪ/tmp/.s.PGSQL.5432 dbaddr ַӦΪ /tmp
	 *  ע⣺ע unix ׽ӿڵ mysql Ĳͬmysql ׽
	 *  Ϊȫ·
	 * @param dbname {const char*} ݿ
	 */
	pgsql_conf(const char* dbaddr, const char* dbname);

	/**
	 * 캯
	 * @param conf {const pgsql_conf&} ڲᴴö󲢿ò
	 *  
	 */
	pgsql_conf(const pgsql_conf& conf);

	~pgsql_conf(void);

	/**
	 * ݿʱû˺ţô˷ʱ˺
	 * @param dbuser {const char*} û˺ţΪǿַʱЧ
	 * @return {pgsql_conf&}
	 */
	pgsql_conf& set_dbuser(const char* dbuser);

	/**
	 * ݿʱ˺룬ô˷ʱ
	 * @param dbpass {const char*} ˺룬ΪǿַʱЧ
	 * @return {pgsql_conf&}
	 */
	pgsql_conf& set_dbpass(const char* dbpass);

	/**
	 * ݿӳ
	 * @param dblimit {size_t} ӳƣΪ 0 ʱ
	 * @return {pgsql_conf&}
	 */
	pgsql_conf& set_dblimit(size_t dblimit);

	/**
	 * ݿĳʱʱ
	 * @param timeout {int}
	 * @return {pgsql_conf&}
	 */
	pgsql_conf& set_conn_timeout(int timeout);

	/**
	 * öȡݿĳʱʱ
	 * @param timeout {int}
	 * @return {pgsql_conf&}
	 */
	pgsql_conf& set_rw_timeout(int timeout);

	/**
	 * ݿӵַ
	 * @param charset {const char*}
	 * @return {pgsql_conf&}
	 */
	pgsql_conf& set_charset(const char* charset);

	const char* get_dbaddr() const
	{
		return dbaddr_;
	}

	const char* get_dbname() const
	{
		return dbname_;
	}

	const char* get_dbkey() const
	{
		return dbkey_;
	}

	const char* get_dbuser() const
	{
		return dbuser_;
	}

	const char* get_dbpass() const
	{
		return dbpass_;
	}

	size_t get_dblimit() const
	{
		return dblimit_;
	}

	int get_conn_timeout() const
	{
		return conn_timeout_;
	}

	int get_rw_timeout() const
	{
		return rw_timeout_;
	}

	const char* get_charset() const
	{
		return charset_;
	}

private:
	char* dbaddr_;
	char* dbname_;
	char* dbkey_;
	char* dbuser_;
	char* dbpass_;
	char* charset_;
	size_t dblimit_;
	int   conn_timeout_;
	int   rw_timeout_;
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_DB_DISABLE)
