#pragma once
#include "../acl_cpp_define.hpp"
#include <map>
#include "../stdlib/string.hpp"
#include "../connpool/connect_manager.hpp"

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_DB_DISABLE)

namespace acl {

class pgsql_conf;

class ACL_CPP_API pgsql_manager : public connect_manager
{
public:
	pgsql_manager(time_t idle_ttl = 120);
	~pgsql_manager();

	/**
	 * һݿʵ
	 * @param conf {const pgsql_conf&}
	 * @return {pgsql_manager&}
	 */
	pgsql_manager& add(const pgsql_conf& conf);

protected:
	/**
	 *  connect_manager 麯ʵ
	 * @param addr {const char*} ַʽip:port
	 * @param count {size_t} ӳصĴСƣֵΪ 0 ʱû
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 * @return {connect_pool*} شӳض
	 */
	connect_pool* create_pool(const char* addr, size_t count, size_t idx);

private:
	time_t idle_ttl_;       // ݿӵĿйʱ
	std::map<string, pgsql_conf*> dbs_;
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_DB_DISABLE)
