#pragma once
#include "../acl_cpp_define.hpp"
#include "../connpool/connect_manager.hpp"

#if !defined(ACL_DB_DISABLE)

namespace acl {

class ACL_CPP_API sqlite_manager : public connect_manager
{
public:
	/**
	 * 캯
	 * @param charset {const char*} ļַ
	 */
	sqlite_manager(const char* charset = "utf-8");
	~sqlite_manager();

	/**
	* @param dbfile {const char*} sqlite ݿļ
	* @param dblimit {size_t} ݿӳ
	* @return {sqlite_manager&}
	 */
	sqlite_manager& add(const char* dbfile, size_t dblimit);

protected:
	/**
	 *  connect_manager 麯ʵ
	 * @param addr {const char*} ַʽip:port
	 * @param count {size_t} ӳصĴСƣֵΪ 0 ʱû
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 * @return {connect_pool*} شӳض
	 */
	connect_pool* create_pool(const char* addr, size_t count, size_t idx);

private:
	// sqlite ļ
	char* dbfile_;
	char* charset_;
	size_t dblimit_;
};

} // namespace acl

#endif // !defined(ACL_DB_DISABLE)
