#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"
#include <vector>

#ifndef ACL_CLIENT_ONLY

namespace acl {

class string;
class hsrow;

class ACL_CPP_API hsproto : public noncopyable
{
public:
	hsproto(bool cache_enable);
	~hsproto();

	/**
	 * ݿЭ
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param dbn {const char*} ݿ
	 * @param tbl {const char*} ݿ
	 * @param idx {const char*} ֶ
	 * @param flds {const char*} Ҫ򿪵ֶϣʽΪ
	 *  ɷָ ",; \t" ֶָƣ磺user_id,user_name,user_mail
	 * @return {bool} Ƿɹ
	 */
	static bool build_open(string& out, int id,
		const char* dbn, const char* tbl,
		const char* idx, const char* flds);

	/**
	 * ѯݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ 
	 *  иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦڴʱֶθ
	 * @param cond {const char*} ƥΪ
	 *  = ; >= ڵ; > ; < С; <= Сڵ
	 * @param nlimit {int} ƣ0 ʾƸ
	 * @param noffset {int} ʼλ(0ʾӵһʼ)
	 * @return {bool} Ƿɹ
	 */
	static bool build_get(string& out, int id,
		const char* values[], int num,
		const char* cond = "=", int nlimit = 0, int noffset = 0);

	/**
	 * ѯݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param nfld {int} ڴʱֶθ
	 * @param first_value {const char*} һ
	 * @param ... {const char*} бһΪ NULL ʾ
	 * @return {bool} Ƿɹ
	 */
	static bool ACL_CPP_PRINTF(4, 5) build_get(string& out, int id,
		int nfld, const char* first_value, ...);

	/**
	 * ޸ݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ 
	 *  иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦڴʱֶθ
	 * @param to_values {cosnt *[]} ƥֵֵֶֶ˳Ӧ open 
	 *  ֶ˳ͬ
	 * @param to_num {int} to_values 鳤
	 * @param cond {const char*} ƥΪ
	 * @param nlimit {int} ƣ0 ʾƸ
	 * @param noffset {int} ʼλ(0ʾӵһʼ)
	 * @return {bool} Ƿɹ
	 */
	static bool build_mod(string& out, int id,
		const char* values[], int num,
		const char* to_values[], int to_num,
		const char* cond = "=", int nlimit = 0, int noffset = 0);

	/**
	 * ɾݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ 
	 *  иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦڴʱֶθ
	 * @param cond {const char*} ƥΪ
	 * @param nlimit {int} ƣ0 ʾƸ
	 * @param noffset {int} ʼλ(0ʾӵһʼ)
	 * @return {bool} Ƿɹ
	 */
	static bool build_del(string& out, int id, const char* values[],
		int num, const char* cond = "=",
		int nlimit = 0, int noffset = 0);

	/**
	 * ɾݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param nfld {int} ڴʱֶθ
	 * @param first_value {const char*} һ
	 * @param ... {const char*} бһΪ NULL ʾ
	 * @return {bool} Ƿɹ
	 */
	static bool ACL_CPP_PRINTF(4, 5) build_del(string& out, int id,
		int nfld, const char* first_value, ...);

	/**
	 * ݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ 
	 *  иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦڴʱֶθ
	 * @return {bool} Ƿɹ
	 */
	static bool build_add(string& out, int id,
		const char* values[], int num);

	/**
	 * ݿ¼Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param nfld {int} ڴʱֶθ
	 * @param first_value {const char*} һ
	 * @param ... {const char*} бһΪ NULL ʾ
	 * @return {bool} Ƿɹ
	 */
	static bool ACL_CPP_PRINTF(4, 5) build_add(string& out, int id,
		int nfld, const char* first_value, ...);

	/**
	 * ͨõĴݿ⴦Э
	 * @param out {string&} 洢Э
	 * @param id {int} ӦıID
	 * @param oper {const char*} ʽӦĲΪ
	 *  : +
	 *  ѯ: =, >, >=, <, <=
	 *  ޸: =, >, >=, <, <=
	 *  ɾ: =, >, >=, <, <=
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ 
	 *  иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦڴʱֶθ
	 * @param limit_offset {const char*} ҪĲѯΧ
	 * @param mop {char} ɾ޸ĲЧӦĲֱΪ:
	 *  D: ɾ, U: ޸
	 * @param to_values {const char*[]} Ŀֵָ
	 * @param to_num {int} to_values ĳ
	 */
	static void build_request(string& out, int id, const char* oper,
		const char* values[], int num,
		const char* limit_offset, char mop,
		const char* to_values[], int to_num);

	/**
	 * ݿķ
	 * @param nfld {int} 򿪵ıԪظ
	 * @param in {string&} ݿ, βӦò "\r\n"
	 * @param errnum_out {int&} 洢̵ĳţμ: hserror.hpp
	 * @param serror_out {const char*&} 洢̵ĳϢ
	 * @return {bool} Ƿɹ
	 */
	bool parse_respond(int nfld, string& in,
                int& errnum_out, const char*& serror_out);

	/**
	 * ִвѯʱͨ˺òѯĽ
	 * @return {const std::vector<hsrow*>&}
	 */
	const std::vector<hsrow*>& get();

	/**
	 * ûѯеڶβѯʱô˺ϴβѯ
	 */
	void reset();
private:
	bool  debugOn_;
	bool  cache_enable_;
	//int   nfld_;
	int   ntoken_;
	char* buf_ptr_;

	// ѯ
	std::vector<hsrow*> rows_;

	// м¼󻺴棬м¼Ϊ˱֤ڴ
	// ãʹõм¼л棬Ա
	std::vector<hsrow*> rows_cache_;

	// л󼯺
	void clear_cache();

	// һѯ
	hsrow* get_next_row();
};

}  // namespace acl

#endif // ACL_CLIENT_ONLY
