#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"
#include "http_header.hpp"

#ifndef ACL_CLIENT_ONLY

namespace acl {

class session;
class socket_stream;
class HttpServletRequest;
class HttpServletResponse;

/**
 *  HTTP ͻĻ࣬Ҫ̳и
 */
class ACL_CPP_API HttpServlet : public noncopyable
{
public:
	/**
	 * 캯
	 * @param stream {socket_stream*}  acl_master ܿ
	 *  ʱòǿգ apache  CGI ʽʱò
	 *  Ϊ NULL⣬úڲرӣӦӦд
	 *  ĹرԷ acl_master ܹ
	 * @param session {session*} ÿһ HttpServlet һ session 
	 */
	HttpServlet(socket_stream* stream, session* session);

	/**
	 * 캯
	 * @param stream {socket_stream*}  acl_master ܿ
	 *  ʱòǿգ apache  CGI ʽʱò
	 *  Ϊ NULL⣬úڲرӣӦӦд
	 *  ĹرԷ acl_master ܹ
	 * @param memcache_addr {const char*}
	 */
	HttpServlet(socket_stream* stream,
		const char* memcache_addr = "127.0.0.1|11211");

	HttpServlet(void);
	virtual ~HttpServlet(void) = 0;

	session& getSession(void) const
	{
		return *session_;
	}

	socket_stream* getStream(void) const
	{
		return stream_;
	}

	/**
	 * ñַ˱ַڽ HTTP ʱ
	 * ԶַתΪַú doRun ֮ǰòЧ
	 * @param charset {const char*} ַָΪգ
	 *  ַ
	 * @return {HttpServlet&}
	 */
	HttpServlet& setLocalCharset(const char* charset);

	/**
	 *  HTTP Ự IO дʱʱ䣻ú doRun ǰòЧ
	 * @param rw_timeout {int} дʱʱ()
	 * @return {HttpServlet&}
	 */
	HttpServlet& setRwTimeout(int rw_timeout);

	/**
	 *  POST ÷ǷҪ Form ݣĬΪ
	 * ú doRun ֮ǰòЧΪ MIME ʽ
	 * ʹñ˽ݣҲн
	 * @param yes {bool} ǷҪ
	 * @return {HttpServlet&}
	 */
	HttpServlet& setParseBody(bool yes);

	/**
	 *  POST ÷ý󳤶ȣ壬ú
	 *  doRun ֮ǰòЧ
	 * @param length {int} 󳤶ƣ峤ȹֱ
	 *   falseֵ <= 0 ڲ峤ȣøúǰ
	 *  ڲȱʡֵΪ 0
	 * @return {HttpServlet&}
	 */
	HttpServlet& setParseBodyLimit(int length);
	
	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * @return {bool} ش false ʾʧܣӦرӣ
	 *   true ʾɹô˺Ӧüͨж/Ӧ
	 *  ǷҪֳȷʵǷ񱣳ֳ
	 */
	bool start(void);

	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * úȻ start ̣Ȼ start ķؽ/Ӧ
	 * ǷҪ󱣳ֳǷҪͻ˱ֳ
	 * @return {bool} ش false ʾʧܻɹҲ
	 *  ӣӦر
	 */
	virtual bool doRun(void);

	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * @param session {session&} 洢 session ݵĶ
	 * @param stream {socket_stream*}  acl_master ܿ
	 *  ʱòǿգ apache  CGI ʽʱò
	 *  Ϊ NULL⣬úڲرӣӦӦд
	 *  ĹرԷ acl_master ܹ
	 * @return {bool} ش
	 */
	virtual bool doRun(session& session, socket_stream* stream = NULL);

	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * ñζŲ memcached 洢 session 
	 * @param memcached_addr {const char*} memcached ַʽIP:PORT
	 * @param stream {socket_stream*} ͬ
	 * @return {bool} ش
	 */
	virtual bool doRun(const char* memcached_addr, socket_stream* stream);

protected:
	/**
	 *  HTTP Ϊ GET ʽʱõ麯
	 */
	virtual bool doGet(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ websocket ʽʱõ麯
	 */
	virtual bool doWebSocket(HttpServletRequest&, HttpServletResponse&);

	/**
	 * ɵĴ websocket ӿڣ doWebSocket 
	 */
	virtual bool doWebsocket(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ POST ʽʱõ麯
	 */
	virtual bool doPost(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ PUT ʽʱõ麯
	 */
	virtual bool doPut(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ PATCH ʽʱõ麯
	 */
	virtual bool doPatch(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ CONNECT ʽʱõ麯
	 */
	virtual bool doConnect(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ PURGE ʽʱõ麯÷ SQUID Ļ
	 * ʱõ
	 */
	virtual bool doPurge(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ DELETE ʽʱõ麯
	 */
	virtual bool doDelete(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ HEAD ʽʱõ麯
	 */
	virtual bool doHead(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ OPTION ʽʱõ麯
	 */
	virtual bool doOptions(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP Ϊ PROPFIND ʽʱõ麯
	 */
	virtual bool doPropfind(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP 󷽷δ֪ʱõ麯
	 * @param method {const char*} δ֪󷽷
	 */
	virtual bool doOther(HttpServletRequest&, HttpServletResponse&,
		const char* method);

	/**
	 *  HTTP 󷽷δ֪ʱõ麯
	 */
	virtual bool doUnknown(HttpServletRequest&, HttpServletResponse&);

	/**
	 *  HTTP ʱõ麯
	 */
	virtual bool doError(HttpServletRequest&, HttpServletResponse&);

protected:
	HttpServletRequest* req_;
	HttpServletResponse* res_;
	bool parse_body_;

private:
	session* session_;
	session* session_ptr_;
	socket_stream* stream_;
	bool first_;
	char local_charset_[32];
	int  rw_timeout_;
	int  parse_body_limit_;
	bool try_old_ws_;

	void init();
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
