#pragma once
#include "../acl_cpp_define.hpp"
#include <vector>
#include "../stdlib/string.hpp"
#include "../stdlib/noncopyable.hpp"
#include "../http/http_header.hpp"
#include "http_ctype.hpp"
#include "http_type.hpp"

#ifndef ACL_CLIENT_ONLY

namespace acl {

class dbuf_guard;
class istream;
class ostream;
class socket_stream;
class http_client;
class http_mime;
class json;
class xml;
class session;
class HttpSession;
class HttpCookie;
class HttpServletResponse;

/**
 *  HTTP ͻص࣬಻Ӧ̳УûҲҪ
 * 򴴽
 */
class ACL_CPP_API HttpServletRequest : public noncopyable
{
public:
	/**
	 * 캯
	 * @param res {HttpServletResponse&}
	 * @param store {session&} 洢ỰݵĶ
	 * @param stream {socket_stream&} ڲر
	 * @param charset {const char*} ֵַǿʱ
	 *  ڲԶ HTTP תΪַת
	 * @param body_limit {int}  POST Ϊı
	 *  ʱ˲ĳȣΪ MIME
	 *  ʽ on Ϊ false˲Ч
	 */
	HttpServletRequest(HttpServletResponse& res, session& store,
		socket_stream& stream, const char* charset = NULL,
		int body_limit = 102400);
	~HttpServletRequest(void);

	/**
	 *  POST ÷ǷҪ Form ݣĬΪ
	 * ú doRun ֮ǰòЧΪ MIME ʽ
	 * ʹñ˽ݣҲн
	 * @param yes {bool} ǷҪ
	 */
	void setParseBody(bool yes);

	/**
	 *  HTTP ͻ󷽷GET, POST, PUT, CONNECT, PURGE
	 * @param method_s {string*} ǿʱ洢ַʽ󷽷
	 * @return {http_method_t}
	 */
	http_method_t getMethod(string* method_s = NULL) const;

	/**
	 *  HTTP ͻ cookie 󼯺
	 * @return {const std::vector<HttpCookie*>&}
	 */
	const std::vector<HttpCookie*>& getCookies(void) const;

	/**
	 *  HTTP ͻĳ cookie ֵ
	 * @param name {const char*} cookie ƣǿ
	 * @return {const char*} cookie ֵ NULL ʾ cookie
	 *  
	 */
	const char* getCookieValue(const char* name) const;

	/**
	 *  HTTP  cookie 
	 * @param name {const char*} cookie ǿַ
	 * @param value {const char*} cookie ֵǿַ
	 */
	void setCookie(const char* name, const char* value);

	/**
	 *  HTTP ͷеĳֵֶ
	 * @param name {const char*} HTTP ͷеֶǿ
	 * @return {const char*} HTTP ͷеֵֶ NULL
	 *  ʱʾ
	 */
	const char* getHeader(const char* name) const;

	/**
	 *  HTTP GET ʽ URL еĲ֣ ? Ĳ
	 * @return {const char*} ûнURL ֣
	 *  ؿմʾ URL ûв
	 */
	const char* getQueryString(void) const;

	/**
	 *   http://test.com.cn/cgi-bin/test?name=value е
	 * /cgi-bin/test ·
	 * @return {const char*} ؿմʾ
	 */
	const char* getPathInfo(void) const;

	/**
	 *   http://test.com.cn/cgi-bin/test?name=value е
	 * /cgi-bin/test?name=value ·
	 * @return {const char*} ؿմʾ
	 */
	const char* getRequestUri(void) const;

	/**
	 *  HTTP Ựص HttpSession 
	 * @param create {bool}  session ʱǷڻԶ
	 *  ĳͻ˵ session ҸòΪ false ʱú
	 *  ص session ûб޷жд
	 * @param sid {const char*}  session ڣ create ǿʱ
	 *   sid ǿգʹôֵûΨһỰͬʱӽͻ˵
	 *  cookie 
	 * @return {HttpSession&}
	 *  עȼ COOKIE > create = true > sid != NULL
	 */
	HttpSession& getSession(bool create = true, const char* sid = NULL);

	/**
	 *  HTTP ͻӹ
	 * @return {istream&}
	 */
	istream& getInputStream(void) const;

	/**
	 *  HTTP ˫ɹ캯Ĳ
	 * @return {socket_stream&}
	 */
	socket_stream& getSocketStream(void) const;

	/**
	 *  HTTP ݵݳ
	 * @return {acl_int64}  -1 ʾΪ GET 
	 *   HTTP ͷû Content-Length ֶ
	 */
#if defined(_WIN32) || defined(_WIN64)
	__int64 getContentLength(void) const;
#else
	long long int getContentLength(void) const;
#endif

	/**
	 * ͻ˵Ƿֶݣúͷеĳʼַ
	 * ַ
	 * @param range_from {long long int&} ƫʼλ
	 * @param range_to {long long int&} ƫƽλ
	 * @return {bool} Ƿֶ򷵻falseǷֶ򷵻true
	 *  עrange_from/range_to ± 0 ʼ
	 */
#if defined(_WIN32) || defined(_WIN64)
	bool getRange(__int64& range_from, __int64& range_to);
#else
	bool getRange(long long int& range_from, long long int& range_to);
#endif
	/**
	 *  HTTP ͷ Content-Type: text/html; charset=gb2312
	 * Content-Type ֵֶ
	 * @param part {bool} Ϊ true 򷵻 text򷵻
	 * ֵ磺text/html; charset=gb2312
	 * @param ctype {http_ctype*} Ϊǿָʱ洢 http_ctype Ϣ
	 * @return {const char*}  NULL ʾ Content-Type ֶβ
	 */
	const char* getContentType(
		bool part = true, http_ctype* ctype = NULL) const;

	/**
	 *  HTTP ͷе Content-Type: text/html; charset=gb2312
	 * е charset ֵֶ gb2312
	 * @return {const char*}  NULL ʾ Content-Type ֶ 
	 *  charset=xxx 
	 */
	const char* getCharacterEncoding(void) const;

	/**
	 * رصֶַ
	 * @ return {const char*}  NULL ʾûñַ
	 */
	const char* getLocalCharset(void) const;

	/**
	 *  HTTP ӵı IP ַ
	 * @return {const char*} ؿգʾ޷
	 */
	const char* getLocalAddr(void) const;

	/**
	 *  HTTP ӵı PORT 
	 * @return {unsigned short}  0 ʾ޷
	 */
	unsigned short getLocalPort(void) const;

	/**
	 *  HTTP ӵԶ̿ͻ IP ַ
	 * @return {const char*} ؿգʾ޷
	 */
	const char* getRemoteAddr(void) const;

	/**
	 *  HTTP ӵԶ̿ͻ PORT 
	 * @return {unsigned short}  0 ʾ޷
	 */
	unsigned short getRemotePort(void) const;

	/**
	 *  HTTP ͷõ Host ֶ
	 * @return {const char*} Ϊգʾ
	 */
	const char* getRemoteHost(void) const;

	/**
	 *  HTTP ͷõ User-Agent ֶ
	 * @return {const char*} Ϊգʾ
	 */
	const char* getUserAgent(void) const;

	/**
	 *  HTTP еĲֵֵѾ URL 
	 * תɱҪַ GET ǻ
	 * URL  ? Ĳֵ POST Ի
	 * URL  ? ĲֵеĲֵ
	 * @param name {const char*} 
	 * @param case_sensitive {bool} ȽʱԲǷִСд
	 * @return {const char*} زֵʱ NULL
	 */
	const char* getParameter(const char* name,
		bool case_sensitive = false) const;

	/**
	 *  HTTP ͷе Content-Type Ϊ
	 * multipart/form-data; boundary=xxx ʽʱ˵Ϊļϴͣ
	 * ͨ˺ http_mime 
	 * @return {const http_mime*}  NULL ˵û MIME 
	 *  صֵûֹͷţΪ HttpServletRequest 
	 *  лԶͷ
	 */
	http_mime* getHttpMime(void);

	/**
	 * Ϊ text/json  application/json ʽʱɵô˷ȡ json
	 * 岢нɹ󷵻 json 󣬸öڲ
	 *  HttpServletRequest ͷʱ json һͷ
	 * @param body_limit {size_t} ޶峤Էֹڴ
	 *  峬ֵ򷵻شֵΪ 0Ƴ
	 * @return {json*} ؽõ json  NULL ¼ԭ
	 *  1ݳ
	 *  2 json ݸʽ
	 *  3
	 */
	json* getJson(size_t body_limit = 1024000);

	/**
	 * ù淽ƣΨһǽûĶ
	 * @param out {json&}
	 * @param body_limit {size_t} ޶峤Էֹڴ
	 *  峬ֵ򷵻شֵΪ 0Ƴ
	 * @return {bool}  false ԭ£
	 *  1ݳ
	 *  2 json ݸʽ
	 *  3
	 */
	bool getJson(json& out, size_t body_limit = 1024000);

	/**
	 * Ϊ text/xml  application/xml ʽʱɵô˷ȡ xml
	 * 岢нɹ󷵻 mxl 󣬸öڲ
	 *  HttpServletRequest ͷʱ xml һͷ
	 * @param body_limit {size_t} ޶峤Էֹڴ
	 *  峬ֵ򷵻شֵΪ 0Ƴ
	 * @return {xml*} ؽõ xml  NULL ¼ԭ
	 *  1ݳ
	 *  2 xml ݸʽ
	 */
	xml* getXml(size_t body_limit = 1024000);

	/**
	 * ù淽ƣΨһǽûĶ
	 * @param out {xml&}
	 * @param body_limit {size_t} ޶峤Էֹڴ
	 *  峬ֵ򷵻شֵΪ 0Ƴ
	 * @return {bool}  false ԭ£
	 *  1ݳ
	 *  2 xml ݸʽ
	 *  3
	 */
	bool getXml(xml& out, size_t body_limit = 1024000);

	/**
	 *  POST ෽Σֱӵô˷
	 * 
	 * @param body_limit {size_t} ޶峤Էֹڴ
	 *  峬ֵ򷵻شֵΪ 0Ƴ
	 * @return {string*} شĶ󣬷 NULL ԭ
	 *  1ݳ
	 *  2û
	 *  3
	 */
	string* getBody(size_t body_limit = 1024000);

	/**
	 * ù淽ƣΨһǽûĶ
	 * @param out {string&}
	 * @param body_limit {size_t}
	 * @return {bool}  false ԭ£
	 *  1ݳ
	 *  2û
	 *  3
	 */
	bool getBody(string& out, size_t body_limit = 1024000);

	/**
	 *  HTTP ݵ
	 * @return {http_request_t}һ POST еϴļӦãҪ
	 *  úǷϴͣú HTTP_REQUEST_OTHER ʱ
	 *  ûͨ getContentType þַ
	 */
	http_request_t getRequestType(void) const;

	/**
	 *  HTTP ҳ referer URL
	 * @return {const char*} Ϊ NULL ˵ûֱӷʱ URL
	 */
	const char* getRequestReferer(void) const;

	/**
	 * ø HTTP ͷõ http_ctype 
	 * @return {const http_ctype&}
	 */
	const http_ctype& getHttpCtype(void) const;

	/**
	 * ж HTTP ͻǷҪ󱣳ֳ
	 * @return {bool}
	 */
	bool isKeepAlive(void) const;

	/**
	 * ͻҪ󱣳ֳʱ HTTP ͷлñֵʱ
	 * @return {int} ֵ < 0 ʾ Keep-Alive ֶ
	 */
	int getKeepAlive(void) const;

	/**
	 *  HTTP ͻİ汾
	 * @param major {unsigned&} 汾
	 * @param minor {unsigned&} Ŵΰ汾
	 * @return {bool} Ƿɹȡ˿ͻİ汾
	 */
	bool getVersion(unsigned& major, unsigned& minor) const;

	/**
	 *  HTTP ͻֵ֧ѹ㷨
	 * @param out {std::vector<string>&} 洢
	 */
	void getAcceptEncoding(std::vector<string>& out) const;

	/*
	 *  HTTP Ϊ POST ͨö HTTP 
	 * IO ʱʱֵ()
	 * @param rw_timeout {int} ʱĳʱʱ()
	 */
	void setRwTimeout(int rw_timeout);

	/**
	 * ϴγĴ
	 * @return {http_request_error_t}
	 */
	http_request_error_t getLastError(void) const;

	/**
	 *  HttpServlet Էģʽ( CGI ʽ)ʱԵô
	 * ÿͻӵ HTTP 󣬴ӶøĲ
	 * @return {http_client*} Էģʽʱ˺ HTTP ͻ
	 *  ӷǿն󣻵 CGI ʽʱ򷵻ؿָ
	 */
	http_client* getClient(void) const;

	/**
	 *  HTTP ͷУļ
	 * @param out {ostream&}
	 * @param prompt {const char*} ʾ
	 */	 
	void fprint_header(ostream& out, const char* prompt);

	/**
	 *  HTTP ͷ
	 * @param out {string&}
	 * @param prompt {const char*} ʾ
	 */
	void sprint_header(string& out, const char* prompt);

private:
	dbuf_guard* dbuf_internal_;
	dbuf_guard* dbuf_;
	http_request_error_t req_error_;
	char cookie_name_[64];
	HttpServletResponse& res_;
	session& store_;
	HttpSession* http_session_;
	socket_stream& stream_;
	int  body_limit_;
	bool body_parsed_;

	std::vector<HttpCookie*> cookies_;
	bool cookies_inited_;
	http_client* client_;
	http_method_t method_;
	bool cgi_mode_;
	http_ctype content_type_;
	char localAddr_[32];
	char remoteAddr_[32];
	char localCharset_[32];
	int  rw_timeout_;
	std::vector<HTTP_PARAM*> params_;
	http_request_t request_type_;
	bool parse_body_;
	http_mime* mime_;
	string* body_;
	json* json_;
	xml* xml_;

	bool readHeaderCalled_;
	bool readHeader(string* method_s);

	void add_cookie(char* data);
	void parseParameters(const char* str);
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
