#pragma once
#include "../acl_cpp_define.hpp"
#include "HttpServlet.hpp"

#ifndef ACL_CLIENT_ONLY

namespace acl
{

class websocket;
class session;
class HttpServletRequest;
class HttpServletResponse;

class ACL_CPP_API WebSocketServlet : public HttpServlet
{
public:
	WebSocketServlet(void);

	/**
	 * 캯
	 * @param stream {socket_stream*}  acl_master ܿ
	 *  ʱòǿգ apache  CGI ʽʱò
	 *  Ϊ NULL⣬úڲرӣӦӦд
	 *  ĹرԷ acl_master ܹ
	 * @param session {session*} ÿһ HttpServlet һ session 
	 */
	WebSocketServlet(socket_stream* stream, session* session);

	/**
	 * 캯
	 * @param stream {socket_stream*}  acl_master ܿ
	 *  ʱòǿգ apache  CGI ʽʱò
	 *  Ϊ NULL⣬úڲرӣӦӦд
	 *  ĹرԷ acl_master ܹ
	 * @param memcache_addr {const char*}
	 */
	WebSocketServlet(socket_stream* stream,
		const char* memcache_addr = "127.0.0.1:11211");

	/**
	 * HttpServlet ʼУ HTTP 󣬲ص doXXX 麯
	 * úȻ start ̣Ȼ start ķؽ/Ӧ
	 * ǷҪ󱣳ֳǷҪͻ˱ֳ.
	 */

	virtual ~WebSocketServlet(void);

	// @override
	bool doRun(void);

	// @override
	bool doRun(session& session, socket_stream* stream = NULL);

	// @override
	bool doRun(const char* memcached_addr, socket_stream* stream);

	/**
	 * Ͷ.
	 * @param buf {const char *} ͵
	 * @param len {int} buf ݳ
	 * @return {bool}  false,  true
	 */
	bool sendBinary(const char *buf, int len);

	/**
	 * ı.
	 * @param text {const char *} ͵
	 * @return {bool}  false,  true
	 */
	bool sendText(const char *text);

	/**
	 * pong Ϣ.
	 * @param buffer {const char *} ͵
	 * @return {bool}  false,  true
	 */
	bool sendPong(const char *buffer = NULL);

	/**
	 * pong Ϣ.
	 * @param buffer {const char *} ͵
	 * @return {bool}  false,  true
	 */
	bool sendPing(const char *buffer = NULL);

protected:
	/**
	 * websocket رϢص
	 */
	virtual void onClose(void) {}

	/**
	 * websocket ping Ϣص.
	 * @param payload_len {unsigned long long} Ϣܳ
	 * @param finish {bool} ݰǷһ
	 * @return {bool} false Ͽӡ
	 */
	virtual bool onPing(unsigned long long payload_len, bool finish) = 0;

	/**
	 * websocket pong Ϣص.
	 * @param payload_len {unsigned long long} Ϣܳ
	 * @param finish {bool} ݰǷһ
	 * @return {bool} false Ͽӡ
	 */
	virtual bool onPong(unsigned long long payload_len, bool finish) = 0;

	/**
	 * websocket ping Ϣص.
	 * @param payload_len {unsigned long long} Ϣܳ
	 * @param text {bool } true ʾΪı,  ݡ
	 * @param finish {bool} ݰǷһ
	 * @return {bool} false Ͽӡ
	 */
	virtual bool onMessage(unsigned long long payload_len,
			bool text, bool finish) = 0;

	/**
	 * ѭô˷֡壬ֱ <= 0 Ϊֹ
	 * @param buf {size_t*} ݻŽ
	 * @param size {size_t} buf С
	 * @return {int} ݳȣΣ
	 *   0: ʾ֡
	 *  -1: ʾ
	 *  >0: ʾݣӦٴεñԱµ
	 */
	int readPayload(void* buf, size_t size);

	/**
	 *  websocket  NULL ʾδ websocket 
	 * @return {websocket*}
	 */
	websocket* get_websocket(void) const
	{
		return ws_;
	}

private:
	// @override
	bool doWebSocket(HttpServletRequest&, HttpServletResponse&);

private:
	websocket *ws_;
	int   opcode_;
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
