#pragma once
#include "../acl_cpp_define.hpp"
#include <list>
#include "../stdlib/dbuf_pool.hpp"
#include "../http/http_type.hpp"

struct HTTP_HDR_RES;
struct HTTP_HDR_REQ;
struct HTTP_HDR_ENTRY;

namespace acl {

class string;
class HttpCookie;

/**
 * HTTP ͷ࣬ԹͷӦͷ
*/
class ACL_CPP_API http_header : public dbuf_obj
{
public:
	/**
	 * 캯
	 * @param dbuf {dbuf_guard*} ǿʱΪڴ
	 */
	http_header(dbuf_guard* dbuf = NULL);

	/**
	 * HTTP ͷ캯
	 * @param url {const char*}  URLurl ʽʾ£
	 *   http://www.test.com/
	 *   /cgi-bin/test.cgi
	 *   http://www.test.com/cgi-bin/test.cgi
	 *   http://www.test.com/cgi-bin/test.cgi?name=value
	 *   /cgi-bin/test.cgi?name=value
	 *  url ֶΣڲԶ
	 *  url вֶΣڲԶд add_param 
	 * øúûԿԵ add_param Ⱥ
	 * ֶֻвûвֵʱòᱻԣ
	 * ӲӦõ add_param 
	 * @param dbuf {dbuf_guard*} ǿʱΪڴ
	 * @param encoding {bool} ǷԴ url еĲ url 룬Ϊ
	 *  true ½ url ¶ url еĲб룬 url ԭ
	 */
	http_header(const char* url, dbuf_guard* dbuf = NULL,
		bool encoding = true);

	/**
	 * HTTP Ӧͷ캯
	 * @param status {int} ״̬磺1xx, 2xx, 3xx, 4xx, 5xx
	 * @param dbuf {dbuf_guard*} ǿʱΪڴ
	 */
	http_header(int status, dbuf_guard* dbuf = NULL);

	/**
	 *  C  HTTP Ӧͷй
	 * @param hdr_res {const HTTP_HDR_RES&}
	 * @param dbuf {dbuf_guard*} ǿʱΪڴ
	 */
	http_header(const HTTP_HDR_RES& hdr_res, dbuf_guard* dbuf = NULL);

	/**
	 *  C  HTTP ͷй
	 * @param hdr_req {const HTTP_HDR_REQ&}
	 * @param dbuf {dbuf_guard*} ǿʱΪڴ
	 */
	http_header(const HTTP_HDR_REQ& hdr_req, dbuf_guard* dbuf = NULL);

	virtual ~http_header(void);

	/**
	 *  HTTP ͷϢͬʱϴεʱԴͷ
	 */
	void reset(void);

	//////////////////////////////////////////////////////////////////////
	//            HTTP  HTTP Ӧͨõķ
	//////////////////////////////////////////////////////////////////////

	/**
	 *  HTTP Э汾
	 * @param version {const char*} HTTP Э汾ţʽ1.0, 1.1
	 * @return {http_header&}
	 */
	http_header& set_proto_version(const char* version);

	/**
	 *  HTTP ͷǿͻ˵ͷǷӦͷ
	 * @param onoff {bool} true ʾͷʾӦͷ
	 * @return {http_header&} رãû
	 */
	http_header& set_request_mode(bool onoff);

	/**
	 *  HTTP ͷֶ
	 * @param name {const char*} ֶǿָ
	 * @param value {const char*} ֵֶǿָ
	 * @param replace {bool} ظʱǷԶǾ
	 * @return {http_header&} رãû
	 */
	http_header& add_entry(const char* name, const char* value,
			bool replace = true);
	
	/**
	 *  HTTP ͷлָͷֶ
	 * @param name {const char*} ֶǿָ
	 * @return {const char*} ֵ NULL ʾ
	 */
	const char* get_entry(const char* name) const;

	/**
	 *  HTTP ͷе Content-Length ֶ
	 * @param n {int64} ֵ
	 * @return {http_header&} رãû
	 */
#if defined(_WIN32) || defined(_WIN64)
	http_header& set_content_length(__int64 n);

	/**
	 * ͨ set_content_length õ HTTP ͷе Content-Length ֵ
	 * @return {int64}
	 */
	__int64 get_content_length() const
	{
		return content_length_;
	}
#else
	http_header& set_content_length(long long int n);
	long long int get_content_length() const
	{
		return content_length_;
	}
#endif

	/**
	 *  HTTP ͷӦͷе Range ֶΣڷֶӦݣ
	 * ֶ֧ϵ WEB 
	 * @param from {http_off_t} ʼƫλã± 0 ʼ
	 *  ֵ >= 0 ʱЧ
	 * @param to {http_off_t} ƫλã± 0 ʼ
	 *  ͷеֵ < 0 ʱΪʼλÿʼճλ
	 * @return {http_header&} رãû
	 */
#if defined(_WIN32) || defined(_WIN64)
	http_header& set_range(__int64 from, __int64 to);
#else
	http_header& set_range(long long from, long long to);
#endif

	/**
	 * ӦͷڷֶδǰҪô˺ܳ
	 * @param total {http_off_t} ӦͷòҪΪܳ
	 * @return {http_header&}
	 */
#if defined(_WIN32) || defined(_WIN64)
	http_header& set_range_total(__int64 total);
#else
	http_header& set_range_total(long long total);
#endif

	/**
	 *  set_range õķֶλֵ
	 * @param from {http_off_t*} ǿʱ洢ʼλƫ
	 * @param to {http_off_t*} ǿʱ洢λƫ
	 */
#if defined(_WIN32) || defined(_WIN64)
	void get_range(__int64* from, __int64* to);
#else
	void get_range(long long int* from, long long int* to);
#endif

	/**
	 *  HTTP ͷе Content-Type ֶ
	 * @param value {const char*} ֵ
	 * @return {http_header&} رãû
	 */
	http_header& set_content_type(const char* value);

	/**
	 *  HTTP ͷе Connection ֶΣǷ񱣳ֳ
	 * Ŀǰδֳ֧ӣʹ˸ñ־λ
	 * õӦݺҲر
	 * @param on {bool} Ƿ񱣳ֳ
	 * @return {http_header&} رãû
	 */
	http_header& set_keep_alive(bool on);

	/**
	 * 鵱ǰͷǷ˱ֳѡ
	 */
	bool get_keep_alive() const
	{
		return keep_alive_;
	}

	http_header& set_upgrade(const char* value = "websocket");
	const char* get_upgrade(void) const
	{
		return upgrade_;
	}

	/**
	 *  HTTP ͷ cookie
	 * @param name {const char*} cookie 
	 * @param value {const char*} cookie ֵ
	 * @param domain {const char*} 
	 * @param path {const char*} 洢·
	 * @param expires {time_t} ʱ䣬ֵΪ 0 ʱʾڣ
	 *  > 0 ʱ expires Ϊʱ䣬λΪ
	 * @return {http_header&} رãû
	 */
	http_header& add_cookie(const char* name, const char* value,
		const char* domain = NULL, const char* path = NULL,
		time_t expires = 0);

	/**
	 *  HTTP ͷ cookie
	 * @param cookie {const http_cookie*} cookie 
	 * @return {http_header&} رãû
	 */
	http_header& add_cookie(const HttpCookie* cookie);

	/**
	 *  HTTP ͷлöӦƵ cookie 
	 * @param name {const char*} cookie 
	 * @return {const HttpCookie*}
	 */
	const HttpCookie* get_cookie(const char* name) const;

	/**
	 * ͵תΪ rfc1123 ַʽ
	 */
	static void date_format(char* out, size_t size, time_t t);

	/**
	 * жǷ HTTP ͷ
	 * @return {bool}  false  HTTP Ӧͷ
	 */
	bool is_request(void) const;

	/**
	 * ñ־λ HTTP  URI е ? ʺűת(ת %3F)Ƿ
	 * ԴڲȱʡΪԴ
	 * @param on {bool} Ϊ true ʾԴ
	 */
	static void uri_unsafe_correct(bool on);

	//////////////////////////////////////////////////////////////////////
	//                        HTTP 󷽷
	//////////////////////////////////////////////////////////////////////
	
	/**
	 *  HTTP ͷ
	 * @param buf {string&} 洢
	 * @return {bool} ͷзɹ
	 */
	bool build_request(string& buf) const;

	/**
	 *  URLurl ʽʾ£
	 * 1http://www.test.com/
	 * 2/cgi-bin/test.cgi
	 * 3http://www.test.com/cgi-bin/test.cgi
	 * 3http://www.test.com/cgi-bin/test.cgi?name=value
	 * 4/cgi-bin/test.cgi?name=value
	 * 5http://www.test.com
	 *  url ֶΣڲԶ
	 *  url вֶΣڲԶд add_param 
	 * øúûԿԵ add_param Ⱥ
	 * ֶֻвûвֵʱòᱻԣ
	 * ӲӦõ add_param 
	 * @param url {const char*}  urlǿָ
	 * @param encoding {bool} ǷԴ url еĲ url 룬Ϊ
	 *  true ½ url ¶ url еĲб룬 url ԭ
	 * @return {http_header&} رãû
	 */
	http_header& set_url(const char* url, bool encoding = true);

	/**
	 *  HTTP ͷ HOST ֶ
	 * @param value {const char*} ͷ HOST ֵֶ
	 * @return {http_header&} رãû
	 */
	http_header& set_host(const char* value);

	/**
	 * õ HTTP ͷе HOST ֶ
	 * @return {const char*} ؿָʾû HOST ֶ
	 */
	const char* get_host() const
	{
		return host_[0] == 0 ? NULL : host_;
	}

	/**
	 *  HTTP Э󷽷ô˺Ĭ GET 
	 * @param method {http_method_t} HTTP 󷽷
	 * @return {http_header&} رãû
	 */
	http_header& set_method(http_method_t method);

	/**
	 *  HTTP Э󷽷ûչ HTTP 󷽷
	 * ͨúõ󷽷Ӱ HTTP 
	 * @param method {const char*} 󷽷
	 * @return {http_header&} رãû
	 */
	http_header& set_method(const char* method);

	/**
	 * Ϊͷʱȡõǰʼͷ󷽷
	 * @param buf {string*} 洢ַʾ󷽷
	 * @return {http_method_t}
	 */
	http_method_t get_method(string* buf = NULL) const;

	/**
	 *  HTTP ͷǷѹݣӦ HTTP ͷֶΪ
	 * Accept-Encoding: gzip, deflateĿǰ֧ gzip ʽ
	 * @param on {bool} Ϊ true Զ HTTP ѹͷ
	 * @return {http_header&} رãû
	 */
	http_header& accept_gzip(bool on);

	/**
	 * ڵ add_param/add_int/add_format ʱǷͬ
	 * ڲȱʡֵΪ񣬼Ȳͬ
	 * @param yes {bool}
	 * @return {http_header&}
	 */
	http_header& set_param_override(bool yes);

	/**
	 *  URL Ӳԣֻвûвֵʱ
	 * 1ǿմֵΪָ룬 URL ֻУ{name}
	 * 2ǿմֵΪմ URLΪ{name}=
	 * @param name {const char*} Ϊָ
	 * @param value {const char*} ֵΪָʱӲ
	 * @return {http_header&} رãû
	 */
	http_header& add_param(const char* name, const char* value);
	http_header& add_int(const char* name, short value);
	http_header& add_int(const char* name, int value);
	http_header& add_int(const char* name, long value);
	http_header& add_int(const char* name, unsigned short value);
	http_header& add_int(const char* name, unsigned int value);
	http_header& add_int(const char* name, unsigned long value);
	http_header& add_format(const char* name, const char* fmt, ...)
		ACL_CPP_PRINTF(3, 4);
#if defined(_WIN32) || defined(_WIN64)
	http_header& add_int(const char* name, __int64 vlaue);
	http_header& add_int(const char* name, unsigned __int64 vlaue);
#else
	http_header& add_int(const char* name, long long int value);
	http_header& add_int(const char* name, unsigned long long int value);
#endif

	http_header& set_ws_origin(const char* url);
	http_header& set_ws_key(const void* key, size_t len);
	http_header& set_ws_key(const char* key);
	http_header& set_ws_protocol(const char* proto);
	http_header& set_ws_version(int ver);

	const char* get_ws_origin(void) const
	{
		return ws_origin_;
	}

	const char* get_ws_key(void) const
	{
		return ws_sec_key_;
	}

	const char* get_ws_protocol(void) const
	{
		return ws_sec_proto_;
	}

	int get_ws_version(void) const
	{
		return ws_sec_ver_;
	}

	http_header& set_ws_accept(const char* key);
	const char* get_ws_accept(void) const
	{
		return ws_sec_accept_;
	}

	/**
	 * url ض
	 * @param url {const char*} ض URLʽΪ
	 *  http://xxx.xxx.xxx/xxx  /xxx
	 *  ǰߣԶȡ HOST ֶΣǺߣ
	 *  ֮ǰ HOST
	 */
	bool redirect(const char* url);

	/**
	 * ضֵ == 0 ض򣬷
	 * ضضĴɸֵ
	 * @param n {int} ضĴ
	 * @return {http_header&} رãû
	 */
	http_header& set_redirect(unsigned int n = 5);

	/**
	 * ȡͨ set_redirect õض
	 * @return {unsigned int}
	 */
	unsigned int get_redirect(void) const;

	/**
	 * Ҫضʱô˺һЩù
	 */
	virtual void redicrect_reset(void) {}

	//////////////////////////////////////////////////////////////////////
	//                       HTTP Ӧ
	//////////////////////////////////////////////////////////////////////

	/**
	 *  HTTP Ӧͷ
	 * @param buf {string&} 洢
	 * @return {bool} Ӧͷзɹ
	 */
	bool build_response(string& buf) const;

	/**
	 *  HTTP ӦͷеӦ״̬
	 * @param status {int} ״̬磺1xx, 2xx, 3xx, 4xx, 5xx
	 * @return {http_header&} رãû
	 */
	http_header& set_status(int status);

	/**
	 * Ӧͷе HTTP ״̬
	 * @return {int} HTTP Ӧ״̬룺1xx, 2xx, 3xx, 4xx, 5xx
	 */
	int get_status(void) const
	{
		return status_;
	}

	/**
	 *  HTTP Ӧͷе chunked ־
	 * @param on {bool}
	 * @return {http_header&}
	 */
	http_header& set_chunked(bool on);

	/**
	 * жϵǰ HTTP Ƿ chunked ䷽ʽ
	 * @return {bool}
	 */
	bool chunked_transfer(void) const
	{
		return chunked_transfer_;
	}

	/**
	 * Ƿ CGI ʽӦͷ
	 * @param on {bool} Ƿ CGI ʽӦͷ
	 * @return {http_header&} رãû
	 */
	http_header& set_cgi_mode(bool on);

	/**
	 * Ƿ CGI ģʽ
	 * @return {bool}
	 */
	bool is_cgi_mode() const
	{
		return cgi_mode_;
	}

	/**
	 * ôǷ gzip ʽѹ
	 * @param on {bool}
	 * @return {http_header&}
	 */
	http_header& set_transfer_gzip(bool on);

	/**
	 * õǰݴǷ˲ gzip ѹʽ
	 * @return {bool}
	 */
	bool is_transfer_gzip() const
	{
		return transfer_gzip_;
	}

private:
	dbuf_guard* dbuf_internal_;
	dbuf_guard* dbuf_;
	bool fixed_;                          // HTTP ǷѾ
	//char* domain_;  // HTTP 
	//unsigned short port_;               // HTTP ˿
	char* url_;                           // HTTP  URL
	std::list<HTTP_PARAM*> params_;       // 
	bool param_override_;                 // ӲʱǷ񸲸ͬ
	std::list<HttpCookie*> cookies_;      // cookies 
	std::list<HTTP_HDR_ENTRY*> entries_;  // HTTP ͷиֶμ
	http_method_t method_;                // HTTP ķ
	char  version_[8];                    // HTTP Э汾
	char  method_s_[64];                  // HTTP 󷽷ַʾ
	char  host_[256];                     // HTTP ͷе HOST ֶ
	bool keep_alive_;                     // Ƿ񱣳ֳ
	unsigned int nredirect_;              // ضĴ
	bool accept_compress_;                // Ƿѹ
	int  status_;                         // Ӧͷ״̬
	bool is_request_;                     // ͷӦͷ
	bool cgi_mode_;                       // Ƿ CGI Ӧͷ
#if defined(_WIN32) || defined(_WIN64)
	__int64 range_from_;                  // ͷУrange ʼλ
	__int64 range_to_;                    // ͷУrange λ
	__int64 range_total_;                 // range ģʽ¼¼ܳ
	__int64 content_length_;              // HTTP 峤
#else
	long long int range_from_;            // ͷУrange ʼλ
	long long int range_to_;              // ͷУrange λ
	long long int range_total_;           // range ģʽ¼¼ܳ
	long long int content_length_;        // HTTP 峤
#endif
	bool chunked_transfer_;               // ǷΪ chunked ģʽ
	bool transfer_gzip_;                  // Ƿ gzip ѹ

	char* upgrade_;
	// just for websocket
	char* ws_origin_;
	char* ws_sec_key_;
	char* ws_sec_proto_;
	int   ws_sec_ver_;
	char* ws_sec_accept_;

	void init(void);                      // ʼ
	void clear(void);
	void build_common(string& buf) const; // ͨͷ

	void add_res_cookie(const HTTP_HDR_ENTRY& entry);
	void append_accept_key(const char* sec_key, string& out) const;
	unsigned char* create_ws_key(const void* key, size_t len) const;
};

}  // namespace acl end
