#pragma once
#include "master_base.hpp"
#include "../stdlib/thread_mutex.hpp"

#ifndef ACL_CLIENT_ONLY

struct ACL_VSTREAM;
struct ACL_EVENT;
struct ACL_VSTRING;
struct acl_pthread_pool_t;

namespace acl {

class socket_stream;

/**
 * ̳߳ط࣬Ϊ࣬ҪʵеĴ麯
 * ÿһ̽һʵᱻֹ
 */
class ACL_CPP_API master_threads : public master_base
{
public:
	/**
	 * ʼУøúָ÷ acl_master 
	 * ֮Уһ״̬
	 * @param argc {int}  main дݵĵһʾ
	 * @param argv {char**}  main дݵĵڶ
	 */
	void run_daemon(int argc, char** argv);

	/**
	 * ڵʱĴûԵô˺һЩҪĵԹ
	 * @param addrs {const char*} ַбʽIP:PORT, IP:PORT...
	 * @param path {const char*} ļȫ·
	 * @param count {unsigned int} ѭĴﵽֵԶأ
	 *  ֵΪ 0 ʾһֱѭ
	 * @param threads_count {int} ֵ 1 ʱʾԶ̳߳طʽ
	 *  ֵֻе count != 1 ʱЧ count == 1 һξͷ
	 *  Ҳ̴߳ͻ
	 * @return {bool} Ƿɹ
	 *  עcount, threads_count Чʹļе
	 *  ֵ ioctl_use_limit(ƴӵĸ)  ioctl_max_threads(
	 *  ߳)
	 */
	bool run_alone(const char* addrs, const char* path = NULL,
		unsigned int count = 1, int threads_count = 1);
	
	/**
	 * Ŀɶ״̬
	 * @param stream {socket_stream*}
	 */
	void thread_enable_read(socket_stream* stream);

	/**
	 * ټĿɶ״̬
	 * @param stream {socket_stream*}
	 */
	void thread_disable_read(socket_stream* stream);

	/**
	 * ļ·
	 * @return {const char*} ֵΪ NULL ʾûļ
	 */
	const char* get_conf_path(void) const;

	/**
	 * õǰ̳߳ضлѹĴ API ԷӦþʱ
	 * Ҫйرѹʱ򽫺
	 * @return {size_t}
	 */
	size_t task_qlen(void) const;

public:
	/**
	 *  lib_acl C е̳߳ؾ
	 * @return {acl_pthread_pool_t*}
	 */
	acl_pthread_pool_t* threads_pool(void) const;

protected:
	// ಻ֱӱʵ
	master_threads();
	virtual ~master_threads();

	/**
	 * 麯ĳͻݿɶرջʱô˺
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾغҪرӣ
	 *  ʾҪֳӣӦӦ÷ false
	 */
	virtual bool thread_on_read(socket_stream* stream) = 0;

	/**
	 * ڵ thread_on_read ䷵ true 󣬻Զñ
	 * жǷǷɶ
	 * @param stream {socket_stream*}
	 * @return {bool}  falseܲټظ
	 */
	virtual bool keep_read(socket_stream* stream)
	{
		(void) stream;
		return true;
	}

	/**
	 * ̳߳еĳ̻߳һʱĻصһЩ
	 * ʼú̵߳߳̿ռ
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾҪرӣ
	 *  ؽٴ thread_main 
	 */
	virtual bool thread_on_accept(socket_stream* stream)
	{
		(void) stream;
		return true;
	}

	/**
	 * յһͻӺ󣬷˻ص˺ͻ˽ֵĲ
	 * ú thread_on_accept ֮󱻵
	 * @return {bool}  false ʾҪرӣ
	 *  ؽٴ thread_main 
	 */
	virtual bool thread_on_handshake(socket_stream *stream)
	{
		(void) stream;
		return true;
	}

	/**
	 * ĳӵ IO дʱʱĻصú true 
	 * ʾȴһζдϣرո
	 * @param stream {socket_stream*}
	 * @return {bool}  false ʾҪرӣҪ
	 *  
	 */
	virtual bool thread_on_timeout(socket_stream* stream)
	{
		(void) stream;
		return false;
	}

	/**
	 * ĳ̰߳󶨵ӹرʱĻص
	 * @param stream {socket_stream*}
	 * ע thread_on_accept  false رʱú
	 * 
	 */
	virtual void thread_on_close(socket_stream* stream) { (void) stream; }

	/**
	 * ̳߳һ̱߳ʱĻص
	 */
	virtual void thread_on_init() {}

	/**
	 * ̳߳һ߳˳ʱĻص
	 */
	virtual void thread_on_exit() {}

	/**
	 * ӽҪ˳ʱܽص˺ܾӽǷ˳ȡڣ
	 * 1) ˺ true ӽ˳
	 * 2) ӽпͻӶѹرգӽ˳
	 * 3) 鿴ļе(ioctl_quick_abort) 0 
	 *    ӽ˳
	 * 4) пͻӹرպ˳
	 * @param nclients {size_t} ǰӵĿͻ˸
	 * @param nthreads {size_t} ǰ̳߳зæĹ̸߳
	 * @return {bool}  false ʾǰӽ̻˳ʾǰ
	 *  ӽ̿˳
	 */
	virtual bool proc_exit_timer(size_t nclients, size_t nthreads)
	{
		(void) nclients;
		(void) nthreads;
		return true;
	}

private:
	thread_mutex lock_;

	void push_back(server_socket* ss);
	void run(int argc, char** argv);

	// յһͻʱص˺
	static int service_main(void*, ACL_VSTREAM*);

	// һַʱص˺
	static void service_on_listen(void*, ACL_VSTREAM*);

	// յһͻʱĻصԽһЩʼ
	static int service_on_accept(void*, ACL_VSTREAM*);

	// յͻӺҪͻһЩȵֶʱ
	// ص˺ú service_on_accept ֮󱻵
	static int service_on_handshake(void*, ACL_VSTREAM*);

	// ͻӶдʱʱĻص
	static int service_on_timeout(void*, ACL_VSTREAM*);

	// ͻӹرʱĻص
	static void service_on_close(void*, ACL_VSTREAM*);

	// лûݺõĻص
	static void service_pre_jail(void*);

	// лûݺõĻص
	static void service_init(void*);

	// Ҫ˳ʱô˺ӦȷǷҪ˳
	static int service_exit_timer(void*, size_t, size_t);

	// ˳ʱõĻص
	static void service_exit(void*);

	// ̴߳õĻص
	static int thread_init(void*);

	// ߳˳ǰõĻص
	static void thread_exit(void*);

	// յ SIGHUP źźص
	static int service_on_sighup(void*, ACL_VSTRING*);
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
