#pragma once
#include "../acl_cpp_define.hpp"
#include "mime_node.hpp"

#if !defined(ACL_MIME_DISABLE)

struct MIME_NODE;

namespace acl {

class pipe_manager;
class ostream;
class pipe_string;
class string;

class ACL_CPP_API mime_body : public mime_node
{
public:
	/**
	 * 캯
	 * @param emailFile {const char*} 洢ʼݵԴļ
	 *  ΪգΪʱڵ save_body ʱָԴļ
	 * @param node {const MIME_NODE*} ʼеĳ
	 * @param htmlFirst {bool} Ƿȡʱȡ HTML 
	 * @param enableDecode {bool} ʼΪ base64/qp ȱʽ
	 *  ʱǷҪԶн
	 * @param toCharset {const char*} ȱʡĿַĿ
	 *  ַԴַַͬת
	 * @param off {off_t} ʼеʼλиӵ
	 *  ƫԱûʼǰԼ˽
	 */
	mime_body(const char* emailFile, const MIME_NODE* node,
		bool htmlFirst = true, bool enableDecode = true,
		const char* toCharset = "gb2312", off_t off = 0)
		: mime_node(emailFile, node, enableDecode, toCharset, off)
		, m_htmlFirst(htmlFirst)
	{
	}

	~mime_body(void) {}

	/**
	 * Ƿȡ HTML , Ϊ true ȡ HTML ,
	 *  HTML ʱŻȡı; Ϊ false 
	 * ȡı,  HTML ʱӸ HTML г
	 * ȡı
	 * @param htmlFirst {bool}
	 */
	void set_status(bool htmlFirst)
	{
		m_htmlFirst = htmlFirst;
	}

	/**
	 * תʼڹܵ
	 * @param out {pipe_manager&} ܵ
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save_body(pipe_manager& out, const char* src = NULL,
		int len = 0);

	/**
	 * תʼ
	 * @param out {ostream&} 
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save_body(ostream& out, const char* src = NULL,
		int len = 0);

	/**
	 * תʼĿļ
	 * @param file_path {const char*} Ŀļ
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save_body(const char* file_path, const char* src = NULL,
		int len = 0);

	/**
	 * תʼڹܵ
	 * @param out {pipe_string&} ܵ
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save_body(pipe_string& out, const char* src = NULL,
		int len = 0);

	/**
	 * תʼڻ
	 * @param out {string&} 
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save_body(string& out, const char* src = NULL,
		int len = 0);

	/**
	 * жϽͷеĴǷ MIME_STYPE_HTML 
	 * @return {bool}
	 */
	bool html_stype(void) const;

private:
	bool m_htmlFirst;
};

} // namespace acl

#endif // !defined(ACL_MIME_DISABLE)
