#pragma once
#include "../acl_cpp_define.hpp"
#include "mime_code.hpp"

#if !defined(ACL_MIME_DISABLE)

namespace acl {

class string;

class ACL_CPP_API mime_quoted_printable : public mime_code
{
public:
	/**
	 * 캯
	 * @param addCrlf {bool} ʽʱǷĩβ "\r\n"
	 * @param addInvalid {bool} ʽʱǷǷַǷԭ
	 */
	mime_quoted_printable(bool addCrlf = false, bool addInvalid = false);
	~mime_quoted_printable(void);

	// 麯

	/* ʽ뺯ʹ÷ encode_update->encode_update->...->encode_finish */

	/**
	 * ʽ뺯
	 * @param src {const char*} ԭʼ
	 * @param n {int} src ݳ
	 * @param out {string*} 洢ͨ out->empty()
	 *   out Ƿнݣ out->length()  out н
	 *  ݵĳȣע⵱ out еĽݺһҪ out->clear()
	 *  ùĽݣҲԶεøú
	 *  encode_finish һȡ
	 */
	void encode_update(const char *src, int n, string* out);

	/**
	 * ʽøúȡĽ
	 * @param out {string*} 洢ͨ out->empty()
	 *   out Ƿнݣ out->length()  out н
	 *  ݵĳȣע⵱ out еĽݺһҪ out->clear()
	 *  ùĽ
	 */
	void encode_finish(string* out);

	/* ʽ뺯ʹ÷ decode_update->decode_update->...->decode_finish */

	/**
	 * ʽ뺯
	 * @param src {const char*} ԭʼ
	 * @param n {int} src ݳ
	 * @param out {string*} 洢ͨ out->empty()
	 *   out Ƿнݣ out->length()  out н
	 *  ݵĳȣע⵱ out еĽݺһҪ out->clear()
	 *  ùĽݣҲԶεøú
	 *  decode_finish һȡ
	 */
	void decode_update(const char *src, int n, string* out);

	/**
	 * ʽøúȡĽ
	 * @param out {string*} 洢ͨ out->empty()
	 *   out Ƿнݣ out->length()  out н
	 *  ݵĳȣע⵱ out еĽݺһҪ out->clear()
	 *  ùĽ
	 */
	void decode_finish(string* out);

	/**
	 * ̬뺯ֱӽݽбͬʱû
	 * û
	 * @param in {const char*} ݵַ
	 * @param n {int} ݳ
	 * @param out {string*} 洢Ļ
	 */
	static void encode(const char* in, int n, string* out);

	/**
	 * ̬뺯ֱӽݽнû
	 * @param in {const char*} ݵַ
	 * @param n {int} ݳ
	 * @param out {string*} 洢
	 */
	static void decode(const char* in, int n, string* out);

	/**
	 * ñࡢ״̬
	 */
	void reset(void);

	/**
	 * ڱʱǷ "\r\n"
	 * @param on {bool}
	 */
	void add_crlf(bool on);

	/**
	 * ڽǷ񿽱Ƿַ
	 * @param on {bool}
	 */
	void add_invalid(bool on);

protected:
private:
	void encode(string* out);
	void decode(string* out);

	bool hex_decode(unsigned char first, unsigned char second,
		unsigned int *result);

	char  m_encodeBuf[72];
	int   m_encodeCnt;
	char  m_decodeBuf[144];
	int   m_decodeCnt;
	bool  m_addCrLf;
	bool  m_addInvalid;
};

}  // namespace acl

#endif // !defined(ACL_MIME_DISABLE)
