#pragma once
#include "noncopyable.hpp"

namespace acl {

class bitmap : public noncopyable
{
public:
	/**
	 * 캯
	 * @param buf {const void*} Դڴλӳ
	 * @param len {size_} buf λӳڴбλ
	 */
	bitmap(const void* buf, size_t len);

	/**
	 * 캯
	 * @param len {size_t} ɵλӳ
	 */
	bitmap(size_t len);

	~bitmap(void);

	/**
	 * ֵӳλ
	 * @param n {size_t}
	 * @return {bool}  true ʾӳɹʾֵԽѾ
	 */
	bool bit_set(size_t n);

	/**
	 * жǷѾλӳ
	 * @param n {size_t}
	 * @return {bool} жֵָǷλӳ伯
	 */
	bool bit_isset(size_t n) const;

	/**
	 * ֵָλȥ
	 * @param n {size_t}
	 * @return {bool}  false ʾֵԽ򲻴λ
	 */
	bool bit_unset(size_t n);

	/**
	 * bitmapϢbuf
	 * @param buf {void*}ſ
	 * @param len {size_t} buf󳤶
	 * @return {size_t} سɹڴ泤ȣ 0 ʾ buf ̫С
	 */
	size_t tobuf(void* buf, size_t len) const;

	/**
	 * bufõǰbitmapϢ
	 * @param buf {const void*} ҪbitmapϢ
	 * @param len {size_t} bufĳ
	 * @return true ɹfalseʧ
	 */
	bool frombuf(const void* buf, size_t len);

	/**
	 * õǰbitmapΪ 0
	 */
	void reset(void);

	/**
	 * ȡǰλӳ洢ռԴ洢λĸ
	 * @return {size_t}
	 */
	size_t size(void) const;

	/**
	 * ڲ洢ռСֽڣ
	 */
	size_t space(void) const;

	/**
	 * ȡǰѾõĸ
	 * @return {size_t}
	 */
	size_t count(void) const;

	/**
	 * ǰbitmapǷ
	 * @return {bool}
	 */
	bool full(void) const;

public:
	const unsigned char* get_bmp(void) const {
		return bmp_;
	}

	unsigned char* get_bmp(void) {
		return bmp_;
	}

private:
	unsigned char *bmp_;
	size_t size_;
	size_t count_;

	//ͳcount
	void recount(void);
};

} // namespace acl
