#pragma once
#include "../acl_cpp_define.hpp"

#ifdef ACL_HOOK_NEW

# if defined(_WIN32) || defined(_WIN64)
#  ifdef NDEBUG
void* operator new(size_t n);
void  operator delete(void *p);
#  endif
# else
#include <new>
void* operator new(size_t n)  throw (std::bad_alloc);
void  operator delete(void *p) throw();
# endif

#elif defined(ACL_CPP_DEBUG_MEM)

/**
 * Ҫ acl еڴǷڴй¶ʱͨ new/delete
 * Ĵٹ¼󱻴ûбͷţڲͻΪ
 * һڴй¶ʹ߿ԶʱЩַϢ鿴ĸļĶû
 * ͷţҪʹô˹ܣ lib_acl_cpp/include/acl_cpp/acl_cpp_define.hpp
 * еĺ "//#define ACL_CPP_DEBUG_MEM" 򿪣ͬʱӦҪԼԴа
 * ͷļ
 * #include "acl_cpp/stdlib/malloc.hpp
 * ӦóڴʱӦʹ NEW  new.
 */
void* operator new(size_t, const char*, const char*, int) throw();
void operator delete(void*) throw();
void operator delete(void*, size_t) throw();

#define NEW new(__FILE__, __FUNCTION__, __LINE__)

namespace acl {

/**
 * ڴع
 */
ACL_CPP_API void mem_checker_start(const char* logfile = NULL);

/**
 * ǰڴ״̬ʾĻʹ߿ԼӶʱʱô˺
 */
ACL_CPP_API void mem_checker_show(void);
}

#endif

namespace acl {

ACL_CPP_API void  acl_slice_init(void);

/**
 * ڴ亯
 * @param size {size_t} ҪĳߴС
 * @param filename {const char*} Դ
 * @param funcname {const char*} 
 * @param lineno {int} Դк
 * @return {void*} ڴַڴʧܣֱabort
 */
ACL_CPP_API void* acl_new(size_t size, const char* filename,
	const char* funcname, int lineno);


/**
 * ͷڴ溯
 * @param ptr {void*} ڴַ
 * @param filename {const char*} Դ
 * @param funcname {const char*} 
 * @param lineno {int} Դк
 */
ACL_CPP_API void  acl_delete(void *ptr, const char* filename,
	const char* funcname, int lineno);

}
