#pragma once
#include "../acl_cpp_define.hpp"
#include <list>
#include <stdlib.h>
#include <string.h>
#include "thread_mutex.hpp"
#include "thread_cond.hpp"
#include "box.hpp"

namespace acl {

/**
 * ֮߳Ϣͨţͨ߳߳ʵ
 *
 * ʾ
 *
 * class myobj {
 * public:
 *     myobj(void) {}
 *     ~myobj(void) {}
 *
 *     void test(void) { printf("hello world\r\n"); }
 * };
 *
 * acl::tbox_array<myobj> tbox;
 *
 * void thread_producer(void)
 * {
 *     myobj* o = new myobj;
 *     tbox.push(o);
 * }
 *
 * void thread_consumer(void)
 * {
 *     myobj* o = tbox.pop();
 *     o->test();
 *     delete o;
 * }
 */

template<typename T>
class tbox_array : public box<T> {
public:
	/**
	 * 췽
	 * @param free_obj {bool}  tbox_array ʱǷԶ鲢ͷ
	 *  δѵĶ̬
	 */
	tbox_array(bool free_obj = true)
	: capacity_(10000)
	, off_curr_(0)
	, off_next_(0)
	, waiters_(0)
	, free_obj_(free_obj)
	, cond_(&lock_)
	{
		array_ = (T**) malloc(sizeof(T*) * capacity_);
	}

	~tbox_array(void)
	{
		clear(free_obj_);
		free(array_);
	}

	/**
	 * ϢδѵϢ
	 * @param free_obj {bool} ͷŵ delete ɾϢ
	 */
	void clear(bool free_obj = false)
	{
		if (free_obj) {
			for (size_t i = off_curr_; i < off_next_; i++) {
				delete array_[i];
			}
		}
	}

	/**
	 * Ϣ󣬱Ƚ֪ͨ
	 * @param t {T*} ǿϢ
	 * @param notify_first {bool} Ϊ true֪ͨȽ
	 *  ֪ͨעߵ
	 * @return {bool}
	 * @override
	 */
	bool push(T* t, bool notify_first = false)
	{
		if (lock_.lock() == false) {
			abort();
		}

		if (off_next_ == capacity_) {
			if (off_curr_ >= 10000) {
#if 1
				size_t n = 0;
				for (size_t i = off_curr_; i < off_next_; i++) {
					array_[n++] = array_[i];
				}
#else
				memmove(array_, array_ + off_curr_,
					(off_next_ - off_curr_) * sizeof(T*));
#endif

				off_next_ -= off_curr_;
				off_curr_ = 0;
			} else {
				capacity_ += 10000;
				array_ = (T**) realloc(array_, sizeof(T*) * capacity_);
			}
		}
		array_[off_next_++] = t;

		if (notify_first) {
			if (cond_.notify() == false) {
				abort();
			}
			if (lock_.unlock() == false) {
				abort();
			}
		} else {
			if (lock_.unlock() == false) {
				abort();
			}
			if (cond_.notify() == false) {
				abort();
			}
		}

		return true;
	}

	/**
	 * Ϣ
	 * @param wait_ms {int} >= 0 ʱõȴʱʱ(뼶)
	 *  ԶȴֱϢ
	 * @param found {bool*} ǿʱǷһϢҪ
	 *  ݿնʱļ
	 * @return {T*}  NULL ʾһϢ󣬷 NULL ʱҪһ
	 *  飬 push һնNULLҲ NULL
	 *  ʱȻΪһϢֻΪն wait_ms 
	 *  Ϊ -1 ʱ NULL ȻΪһϢ wait_ms 
	 *   0 ʱ NULLӦü found ֵΪ true  false 
	 *  жǷһϢ
	 * @override
	 */
	T* pop(int wait_ms = -1, bool* found = NULL)
	{
		long long n = ((long long) wait_ms) * 1000;
		bool found_flag;

		if (lock_.lock() == false) {
			abort();
		}
		while (true) {
			T* t = peek(found_flag);
			if (found_flag) {
				if (lock_.unlock() == false) {
					abort();
				}
				if (found) {
					*found = found_flag;
				}
				return t;
			}

			// ע˳򣬱ȵ wait ж wait_ms
			waiters_++;
			if (!cond_.wait(n, true) && wait_ms >= 0) {
				waiters_--;
				if (lock_.unlock() == false) {
					abort();
				}
				if (found) {
					*found = false;
				}
				return NULL;
			}
			waiters_--;
		}
	}

	/**
	 * tbox пϢ
	 * @return {bool}
	 * @override
	 */
	bool has_null(void) const {
		return true;
	}

	/**
	 * صǰϢеϢ
	 * @return {size_t}
	 */
	size_t size(void) const
	{
		return off_next_ - off_curr_;
	}

public:
	void lock(void)
	{
		if (lock_.lock() == false) {
			abort();
		}
	}

	void unlock(void)
	{
		if (lock_.unlock() == false) {
			abort();
		}
	}

private:
	T**          array_;
	size_t       capacity_;
	size_t       off_curr_;
	size_t       off_next_;
	size_t       waiters_;
	bool         free_obj_;
	thread_mutex lock_;
	thread_cond  cond_;

	T* peek(bool& found_flag)
	{
		if (off_curr_ == off_next_) {
			found_flag = false;
			if (off_curr_ > 0) {
				off_curr_ = off_next_ = 0;
			}
			return NULL;
		}

		found_flag = true;
		T* t = array_[off_curr_++];
		return t;
	}
};

} // namespace acl
