#pragma once
#include "../acl_cpp_define.hpp"
#include "noncopyable.hpp"
#include "string.hpp"
#include <list>

struct ACL_TOKEN;
struct ACL_ITER;

namespace acl {

class token_tree;

/**
 * 256 ƥеĽڵΪ˽
 */
class ACL_CPP_API token_node : public noncopyable
{
public:
	/**
	 * øýڵӦļֵ
	 * @return {const char*}
	 */
	const char* get_key(void) const;

	/**
	 * øýڵ󶨵Ķַ
	 * @return {void*}
	 */
	void* get_ctx(void) const;

	/**
	 * øýڵƥ
	 * @return {token_tree*}
	 */
	token_tree* get_tree(void) const
	{
		return tree_;
	}

	/**
	 *  C 汾Ľڵ
	 * @return {ACL_TOKEN*}
	 */
	ACL_TOKEN* get_token(void) const
	{
		return me_;
	}

private:
	friend class token_tree;	//  token_tree /

	token_node(void);
	~token_node(void);

	void set_node(ACL_TOKEN* token, token_tree* tree);

private:
	ACL_TOKEN*  me_;
	token_tree* tree_;
	string      key_;
	bool        dirty_;
};

/**
 * 256 ƥ㷨㷨ͨԼǳߵ(ȹϣܻ)
 * ַͨӳ䵽 256 Ͻƥ
 */
class ACL_CPP_API token_tree : public noncopyable
{
public:
	token_tree(void);
	~token_tree(void);

	/**
	 * һµ
	 * @param key {const char*} ֵ
	 * @param ctx {void*}  key 󶨵Ķ󣬿Ϊ
	 * @return {bool} Ƿɹ false ͬ key Ѵ
	 */
	bool insert(const char* key, void* ctx = NULL);

	/**
	 * ƥɾָ key 
	 * @param key {const char*} ֵ
	 * @return {void*} ʱ󶨵Ķַ
	 */
	void* remove(const char* key);

	/**
	 * ݼֵȷƥĽڵ
	 * @param key {const char*} ֵ
	 * @return {const token_node*}  NULL ʾδҵƥ
	 */
	const token_node* find(const char* key);

	/**
	 * ַƥģʽƥвıַƥĽڵ㣬ͬʱ
	 * ƶıַָλ
	 * @param text {const char**} ҪƥҵıַƥУ
	 *  ַָᱻƶһλ
	 * @param delimiters {const char*}  NULL ʱָĽַֹ
	 *  ҹֻҪַڸýַֹУ򷵻رβҵĽ
	 * @param delimiters_tab {const char*}  NULL ʱָĽַֹ飬
	 *  ҹֻҪַڸýַֹУ򷵻رβҵĽ
	 *   create_delimiters_tab  free_delimiters_tab ͷ
	 * @return {token_node*}  NULL ʾβδҵƥͨ
	 *  *text ǷΪ '\0' ʾǷƥĿıַ
	 *  ע delimiters ǿʱʹ delimiters Ϊֹټ
	 *  delimiters_tab ǷǿգǿʹΪֹ
	 */
	const token_node* search(const char** text, const char* delimiters = NULL,
		const char* delimiters_tab = NULL);

	/**
	 * ֹ
	 * @param delimiters {const char*} ַֹ
	 * @return {char*} ݽַֹĽֹ
	 */
	static char* create_delimiters_tab(const char* delimiters);

	/**
	 * ͷ create_delimiters_tab Ľֹ
	 * @param delimiters_tab {char*}
	 */
	static void free_delimiters_tab(char* delimiters_tab);

	/**
	 *  256 ƥʱȵñõһڵ
	 * @return {token_node*}
	 */
	const token_node* first_node(void);

	/**
	 *  256 ƥʱȵñһڵ
	 * @return {token_node*}
	 */
	const token_node* next_node(void);

	/**
	 *  C 汾 256 
	 * @return {ACL_TOKEN*}
	 */
	ACL_TOKEN* get_tree(void) const
	{
		return tree_;
	}

private:
	ACL_TOKEN* tree_;
	ACL_ITER*  iter_;
	token_node node_;
};

} // namespace acl
