#pragma once
#include "../acl_cpp_define.hpp"
#include <list>
#include "aio_handle.hpp"
#include "aio_timer_callback.hpp"
#include "aio_stream.hpp"

namespace acl {

class aio_istream;

/**
 * ӳ첽࣬Ϊ aio_timer_callback (see aio_handle.hpp)
 * νӳ첽ǰ첽(aio_istream)ڶʱУ
 * 첽( aio_handle ļн)ָ
 * ʱ䵽첽( timer_callback ص½첽
 * 첽)ͬʱöʱԶ( destroy )
 * û̳ aio_timer_reader ࣬಻ڶϷģ
 *  destroyͬʱ destroy ִԴͷŵ
 * زδ destroy򵱶ʱڲԶ
 *  aio_timer_reader  destroy-- delete thisʱ
 * ᵼ·ǷڴͷŲ)
 * 
 */
class ACL_CPP_API aio_timer_reader : public aio_timer_callback {
public:
	aio_timer_reader(void) : in_(NULL) {}

	/**
	 *  aio_istream еô˺ͷӦʵָú
	 */
	virtual void destroy(void)
	{
		delete this;
	}
protected:
	virtual ~aio_timer_reader(void) {}
	/**
	 * ӳٶʱĻص aio_timer_callback м̳ж
	 */
	virtual void timer_callback(unsigned int id);
private:
	//  aio_istream ֱ޸ı˽гԱ
	friend class aio_istream;

	aio_istream* in_;
	//int   read_delayed_;
	bool  delay_gets_;
	int   delay_timeout_;
	bool  delay_nonl_;
	int   delay_count_;
};

/**
 * 첽ඨ壬ֻڶϱʵʱҪ close
 * ͷŸ
 */
class ACL_CPP_API aio_istream : virtual public aio_stream
{
public:
	/**
	 * 캯
	 * @param handle {aio_handle*} 첽¼
	 */
	aio_istream(aio_handle* handle);

	/**
	 * 캯첽󣬲 hook ̼ر/ʱ
	 * @param handle {aio_handle*} 첽¼
	 * @param fd {int} ׽ӿھ
	 */
#if defined(_WIN32) || defined(_WIN64)
	aio_istream(aio_handle* handle, SOCKET fd);
#else
	aio_istream(aio_handle* handle, int fd);
#endif

	/**
	 * ɶʱĻصָ룬ûصѾڣֻ
	 * ʹöڴ򿪿״̬
	 * @param callback {aio_callback*} ̳ aio_callback ص
	 *  첽ʱȵô˻صе read_callback ӿ
	 */
	void add_read_callback(aio_callback* callback);

	/**
	 * Ӷص󼯺ɾ
	 * @param callback {aio_read_callback*} ɾĻص
	 * ֵΪգɾеĻص
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */

	/**
	 * Ӷص󼯺ɾص
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգɾеĶص
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */
	int del_read_callback(aio_callback* callback = NULL);

	/**
	 * ֹص༯еĳص󣬵ӻص
	 * ɾֻǲö
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգֹеĶص
	 * @return {int} رӻص󼯺нõĻصĸ
	 */
	int disable_read_callback(aio_callback* callback = NULL);

	/**
	 * еĻص󱻵
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգеĶص
	 * @return {int} رõĻصĸ
	 */
	int enable_read_callback(aio_callback* callback = NULL);

	/**
	 * 첽ȡһݣӳ첽ʱô˹̣
	 * ֻһӳٶЧ
	 * @param timeout {int} ʱʱ()Ϊ 0 ʾ
	 *  Զȴֱһݻ
	 * @param nonl {bool} ǷԶȥβĻسз
	 * @param delay {long long int} ԷݱȽϿʱ˲
	 *   0 ʱӳٽնԷݣֵӳٶ
	 *  ʱ(λΪ΢)
	 * @param callback {aio_timer_reader*} ʱʱĻص
	 *   delay > 0ֵΪգȱʡĶ
	 */
	void gets_await(int timeout = 0, bool nonl = true,
		long long int delay = 0, aio_timer_reader* callback = NULL);

	/**
	 * same as gets_await();
	 */
	void gets(int timeout = 0, bool nonl = true,
		long long int delay = 0, aio_timer_reader* callback = NULL)
	{
		gets_await(timeout, nonl, delay, callback);
	}

	/**
	 * 첽ȡݣӳ첽ʱô˹̣
	 * ֻһӳٶЧ
	 * @param count {int} ҪΪ 0 ֻҪ
	 *  ɶͷأֱʱҪֽ
	 * @param timeout {int} ʱʱ()Ϊ 0 ʾ
	 *  ԶȴֱҪݻ
	 * @param delay {long long int} ԷݱȽϿʱ˲
	 *   0 ʱӳٽնԷݣֵӳٶ
	 *  ʱ(λΪ΢)
	 * @param callback {aio_timer_reader*} ʱʱĻص
	 *  ֵΪգȱʡĶ
	 */
	void read_await(int count = 0, int timeout = 0,
		long long int delay = 0, aio_timer_reader* callback = NULL);

	/**
	 * same as read_await()
	 */
	void read(int count = 0, int timeout = 0,
		long long int delay = 0, aio_timer_reader* callback = NULL)
	{
		read_await(count, timeout, delay, callback);
	}

	/**
	 * 첽ȴɶú첽Ķ״̬ݿɶ
	 * ʱصûԼݵĶȡ
	 * @param timeout {int} ʱʱ()ֵΪ 0 ʱûжʱ
	 */
	void readable_await(int timeout = 0);

	/**
	 * same as readable_await()
	 */
	void read_wait(int timeout = 0)
	{
		readable_await(timeout);
	}

	/**
	 * ֹ첽첽״̬첽첽ļ
	 * Ƴֱûκһ첽(ʱ첽
	 * Զ¼ظĿɶ״̬)
	 */
	void disable_read(void);

	/**
	 * ǷӶ
	 * @param onoff {bool}
	 */
	void keep_read(bool onoff);

	/**
	 * Ƿ
	 * @return {bool}
	 */
	bool keep_read(void) const;

	/**
	 * ýջ󳤶ȣԱ⻺ĬֵΪ 0 ʾ
	 * @param max {int}
	 * @return {aio_istream&}
	 */
	aio_istream& set_buf_max(int max);

	/**
	 * õǰջ󳤶
	 * @return {int} ֵ  <= 0 ʾû
	 */
	int get_buf_max(void) const;

	/**
	 * ڲ read_ready flag λ IO ⵽ IO ɶʱ
	 * read_ready ־λһᶨڼñ־λǷãԾǷ
	 * Ҫٴδص̣ͨñ־λIO Ͳ
	 * ӦòþǷɶǽ OS ȥжǷɶ
	 */
	void clear_read_ready(void);

protected:
	virtual ~aio_istream(void);

	/**
	 * ͷŶ̬麯
	 */
	virtual void destroy(void);

	/**
	 * עɶĻص
	 */
	void enable_read(void);

private:
	friend class aio_timer_reader;
	aio_timer_reader* timer_reader_;
	std::list<AIO_CALLBACK*> read_callbacks_;

	static int read_callback(ACL_ASTREAM*,  void*, char*, int);
	static int read_wakeup(ACL_ASTREAM* stream, void* ctx);
};

}  // namespace acl
