#pragma once
#include "../acl_cpp_define.hpp"
#include "aio_stream.hpp"

namespace acl {

class aio_socket_stream;
class aio_listen_stream;

/**
 * 첽յµĿͻʱô˻صеĻصΪ࣬
 * Ҫʵ accept_callback ص
 */
class ACL_CPP_API aio_accept_callback : public aio_callback {
public:
	aio_accept_callback(void) {}
	virtual ~aio_accept_callback(void) {}

	/**
	 * յµĿͻʱĻص
	 * @param client {aio_socket_stream*} ͻ첽
	 *  ԶԴжд
	 * @return {bool} ϣرո첽Է false
	 *  һ㲻Ӧ false
	 */
	virtual bool accept_callback(aio_socket_stream* client) = 0;
};

/**
 * 첽յӵ¼ʱôе麯ʵָ麯
 * е accept() ϵͳ API տͻӣ aio_accept_callback
 * ͬ aio_accept_callback::accept_callback() ʱͻӶ
 * Ѿ listen_callback() УҪӦԼӶ
 */
class ACL_CPP_API aio_listen_callback : public aio_callback {
public:
	aio_listen_callback(void) {}
	virtual ~aio_listen_callback(void) {}

	virtual bool listen_callback(aio_listen_stream& ss) = 0;
};

/**
 * 첽ڿͻ˵ӣͬʱֻ
 * ڶϷ䣬ջ䣬ӦÿԵ close رر
 * 첽Զͷţ delete ɾ
 *
 */
class ACL_CPP_API aio_listen_stream : public aio_stream {
public:
	/**
	 * 캯Թ첽
	 * @param handle {aio_handle*} 첽
	 */
	aio_listen_stream(aio_handle* handle);

	/**
	 * 첽յ¿ͻʱĻص
	 * @param callback {aio_accept_callback*}
	 */
	void add_accept_callback(aio_accept_callback* callback);

	/**
	 * 첽пͻӵʱĻص
	 * @param callback {aio_listen_stream*}
	 *  ע⣺ add_accept_callback 𣬱 reactor
	 *  ģʽ add_accept_callback  proactor ģʽ
	 */
	void add_listen_callback(aio_listen_callback* callback);

	/**
	 *  add_listen_callback ʽʱ aio_listen_callback 
	 * еĺ listen_callback Եñһ첽Ӷ
	 * @return {aio_socket_stream*}  NULL ʾʧ
	 */
	aio_socket_stream* accept(void);

	/**
	 * ʼĳַָΪ׽ӿڣҲΪ׽ӿڣ
	 * @param addr {const char*} ַTCPַַ
	 * ʽ
	 *   TCPӣIP:PORT磺127.0.0.1:9001
	 *   ׽ӿڣ{path}磺/tmp/my.sock Linux ƽ̨֧
	 *   Linux abstract unix domain socketҪַֽΪ'@' Linux
	 *   ƽ̨£acl ڲ⵽·ֽΪ '@'ڲԶе Linux
	 *   abstract unix domain socket ģʽе @ ֻǣ
	 *   ļַԶȥ
	 * @param flag {unsigned} ׽ӿʱĴ򿪱־λ server_socket.hpp
	 * @param qlen {int} ָ׽ּеĳ
	 * @return {bool} Ƿɹ
	 */
	bool open(const char* addr, unsigned flag = 0, int qlen = 128);

	/**
	 * ʹ׽ִ󣬸׽־Ѿ bind/listen 
	 * @param fd {int}
	 * @return {bool} Ƿɹ
	 */
#if defined(_WIN32) || defined(_WIN64)
	bool open(SOCKET fd);
#else
	bool open(int fd);
#endif

	/**
	 * ʹͬ󴴽
	 * @param vstream {ACL_VSTREAM*} ǿն
	 * @return {bool} Ƿɹ
	 */
	bool open(ACL_VSTREAM* vstream);

	/**
	 * ʹ÷󴴽
	 * @param astream {ACL_ASTREAM*} ǿն
	 * @return {bool} Ƿɹ
	 */
	bool open(ACL_ASTREAM* astream);

	/**
	 * ÷ַ
	 * @return {const char*}
	 */
	const char* get_addr(void) const;

	/**
	 * ػ෽첽ʱص˷
	 */
	virtual void destroy(void);

protected:
	virtual ~aio_listen_stream(void);

private:
	bool listen_hooked_;
	char addr_[256];
	std::list<aio_accept_callback*> accept_callbacks_;
	std::list<aio_listen_callback*> listen_callbacks_;

	void enable_listen(void);
	int accept_callback(aio_socket_stream* conn);
	static int listen_callback(ACL_ASTREAM*, void*);
};

}  // namespace acl
