#pragma once
#include "../acl_cpp_define.hpp"
#include <stdarg.h>
#include "../stdlib/string.hpp"
#include "aio_handle.hpp"
#include "aio_timer_callback.hpp"
#include "aio_stream.hpp"

struct iovec;

namespace acl {

class aio_ostream;

/**
 * ӳ첽д࣬Ϊ aio_timer_callback (see aio_handle.hpp)
 * νӳ첽дǰ첽д(aio_ostream)ڶʱУ
 * 첽д( aio_handle ļн)ָ
 * ʱ䵽첽д( timer_callback ص½첽
 * 첽д)ͬʱöʱԶ( destroy )
 * û̳ aio_timer_writer ࣬಻ڶϷģ
 *  destroyͬʱ destroy ִԴͷŵ
 * زδ destroy򵱶ʱڲԶ
 *  aio_timer_writer  destroy-- delete thisʱ
 * ᵼ·ǷڴͷŲ)
 * 
 */
class ACL_CPP_API aio_timer_writer : public aio_timer_callback {
public:
	aio_timer_writer(void);

	/**
	 *  aio_istream еô˺ͷӦʵָú
	 */
	virtual void destroy(void)
	{
		delete this;
	}

protected:
	virtual ~aio_timer_writer(void);

	/**
	 * ӳٶʱĻص aio_timer_callback м̳ж
	 */
	virtual void timer_callback(unsigned int id);
private:
	friend class aio_ostream;

	aio_ostream* out_;
	//int   write_delayed_;
	acl::string buf_;
};

/**
 * 첽дඨ壬ֻڶϱʵʱҪ close
 * ͷŸ
 */
class ACL_CPP_API aio_ostream : virtual public aio_stream {
public:
	/**
	 * 캯
	 * @param handle {aio_handle*} 첽¼
	 */
	aio_ostream(aio_handle* handle);

	/**
	 * 캯첽д󣬲 hook д̼ر/ʱ
	 * @param handle {aio_handle*} 첽¼
	 * @param fd {int} ׽ӿھ
	 */
#if defined(_WIN32) || defined(_WIN64)
	aio_ostream(aio_handle* handle, SOCKET fd);
#else
	aio_ostream(aio_handle* handle, int fd);
#endif

	/**
	 * дʱĻصָ룬ûصѾڣֻ
	 * ʹöڴ򿪿״̬
	 * @param callback {aio_callback*} ̳ aio_callback ص
	 *  첽ʱȵô˻صе write_callback ӿ
	 */
	void add_write_callback(aio_callback* callback);

	/**
	 * дص󼯺ɾ
	 * @param callback {aio_callback*} ɾдص
	 *  ֵΪգɾеĻصд
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */
	int del_write_callback(aio_callback* callback = NULL);

	/**
	 * ֹص༯еĳص󣬵ӻص
	 * ɾֻǲö
	 * @param callback {aio_callback*} õдص
	 *  ֵΪգедص
	 * @return {int} رӻص󼯺нõĻصĸ
	 */
	int disable_write_callback(aio_callback* callback = NULL);

	/**
	 * еĻص󱻵
	 * @param callback {aio_callback*} ָдص
	 *  ֵΪգедص
	 * @return {int} رõдصĸ
	 */
	int enable_write_callback(aio_callback* callback = NULL);

	/**
	 * 첽д涨ֽݣȫдɹʱʱ
	 * ûעĻصӳ첽дʱһ
	 * ô˹ʱÿӳ첽дᱻӳд
	 * ĶУԱ֤ÿӳ첽дڸԵĶʱ
	 * ʱִ
	 * @param data {const void*} ݵַ
	 * @param len {int} ݳ
	 * @param delay {int64} ֵ > 0 ӳٷ͵ģʽ(λΪ΢)
	 * @param callback {aio_timer_writer*} ʱʱĻص
	 */
	void write_await(const void* data, int len, long long int delay = 0,
		aio_timer_writer* callback = NULL);

	/**
	 * same as write_await();
	 */
	void write(const void* data, int len, long long int delay = 0,
		aio_timer_writer* callback = NULL)
	{
		write_await(data, len, delay, callback);
	}

	/**
	 * ñķʽʱɵñĿַݰ
	 * @param data {const void*} ݵַ
	 * @param len {int} ݳ
	 * @param dest_addr {const char*} Ŀַʽip|port
	 * @param flags {int} ͱ־λοϵͳ sendto() api  flags ˵
	 * @return {int}  -1 ʾʧ
	 */
	int sendto(const void* data, int len, const char* dest_addr, int flags = 0);

	/**
	 * ñķʽʱɵñĿַݰ
	 * @param data {const void*} ݵַ
	 * @param len {int} ݳ
	 * @param dest_addr {const sockaddr*} Ŀַʽip|port
	 * @param addrlen {int} dest_addr ַ
	 * @param flags {int} ͱ־λοϵͳ sendto() api  flags ˵
	 * @return {int}  -1 ʾʧ
	 */
	int sendto(const void* data, int len,
		const struct sockaddr* dest_addr, int addrlen, int flags = 0);

	/**
	 * 첽д, дʱдɹʱ¼֪̣ͨ
	 * ϵͳ writev
	 * @param iov {const struct iovec*} ݼ
	 * @param count {int} iov ĳ
	 */
	void writev_await(const struct iovec *iov, int count);

	/**
	 * same as writev_await()
	 */
	void writev(const struct iovec *iov, int count)
	{
		writev_await(iov, count);
	}

	/**
	 * ʽʽ첽дݣȫдɹʱʱ
	 * ûעĻص
	 * @param fmt {const char*} ʽַ
	 */
	void format_await(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * please use format_await() instead
	 */
	void format(const char* fmt, ...) ACL_CPP_PRINTF(2, 3)
	{
		va_list ap;
		va_start(ap, fmt);
		vformat_await(fmt, ap);
		va_end(ap);
	}

	/**
	 * ʽʽ첽дݣȫдɹʱʱ
	 * ûעĻص
	 * @param fmt {const char*} ʽַ
	 * @param ap {va_list} ֵб
	 */
	void vformat_await(const char* fmt, va_list ap);

	/**
	 * same as vformat_await()
	 */
	void vformat(const char* fmt, va_list ap)
	{
		vformat_await(fmt, ap);
	}

	/**
	 * 첽ȴдú첽д״̬пдʱ
	 * صûԼݵĶȡ
	 * @param timeout {int} дʱʱ()ֵΪ <= 0 ʱûдʱ
	 */
	void writable_await(int timeout = 0);

	/**
	 * same as writable_await()
	 */
	void write_wait(int timeout = 0)
	{
		writable_await(timeout);
	}

	/**
	 * ֹ첽첽д״̬򽫸첽첽ļ
	 * ¼ƳֱûκһдʱԶ
	 * д״̬(ʱ±첽)
	 */
	void disable_write(void);

	/**
	 * ÷Ͷݳ
	 * @return {size_t}
	 */
	size_t pending_length(void) const;

protected:
	virtual ~aio_ostream(void);

	/**
	 * ͷŶ̬麯
	 */
	virtual void destroy(void);

	/**
	 * עд
	 */
	void enable_write(void);

private:
	friend class aio_timer_writer;
	std::list<aio_timer_writer*>* timer_writers_;
	std::list<AIO_CALLBACK*> write_callbacks_;

	static int write_callback(ACL_ASTREAM*, void*);
	static int write_wakup(ACL_ASTREAM*, void*);
};

}  // namespace acl
