#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/thread_mutex.hpp"
#include "../stdlib/string.hpp"
#include "sslbase_conf.hpp"
#include <vector>

namespace acl {

/**
 * SSL ֤У鼶Ͷ
 */
typedef enum {
	MBEDTLS_VERIFY_NONE,	// У֤
	MBEDTLS_VERIFY_OPT,	// ѡУ飬ʱֺУ
	MBEDTLS_VERIFY_REQ	// ҪʱУ
} mbedtls_verify_t;

class mbedtls_io;

/**
 * SSL Ӷ࣬һΪȫֶÿһ SSL
 * Ӷ֤ãȫԵ֤顢ԿϢÿһ SSL 
 * (mbedtls_io) ñsetup_certs ʼ֤顢ԿϢ
 */
class ACL_CPP_API mbedtls_conf : public sslbase_conf {
public:
	/**
	 * 캯
	 * @param server_side {bool} ָǷ˻ǿͻˣΪ true ʱ
	 *  ΪģʽΪͻģʽ
	 * @param verify_mode {mbedtls_verify_t} SSL ֤У鼶
	 */
	mbedtls_conf(bool server_side = false,
		mbedtls_verify_t verify_mode = MBEDTLS_VERIFY_NONE);
	~mbedtls_conf(void);

	/**
	 * @override
	 */
	bool load_ca(const char* ca_file, const char* ca_path);

	/**
	 * @override
	 */
	bool add_cert(const char* crt_file, const char* key_file,
		const char* key_pass = NULL);

	/**
	 * @override
	 * ע: ÷ mbedtls_conf н, ֱʹ淽
	 */
	bool add_cert(const char* /* crt_file */);

	/**
	 * @override
	 * ע: ÷ mbedtls_conf н, ֱʹ淽
	 */
	bool set_key(const char* /*key_file*/, const char* /* key_pass */);

	/**
	 * @override
	 */
	void enable_cache(bool on);

public:
	/**
	 * mbedtls_io::open ڲñװǰ SSL Ӷ֤
	 * @param ssl {void*} SSL ӶΪ ssl_context 
	 * @return {bool}  SSL Ƿɹ
	 */
	bool setup_certs(void* ssl);

	/**
	 * ض
	 * @return {void*}ֵΪ entropy_context 
	 */
	void* get_entropy(void)
	{
		return entropy_;
	}

public:
	/**
	 *  mbedtls ֳ⣬Եñ̬ȫ·
	 * @param libmbedcrypto {const char*} libmbedcrypto ̬ȫ·
	 * @param libmbedx509 {const char*} libmbedx509 ̬ȫ·
	 * @param libmbedtls {const char*} libmbedtls ̬ȫ·
	 */
	static void set_libpath(const char* libmbedcrypto,
		const char* libmbedx509, const char* libmbedtls);

	/**
	 *  mbedtls ϳһ⣬Եñһ̬ȫ·
	 * @param libmbedtls {const char*} libmbedtls ̬ȫ·
	 */
	static void set_libpath(const char* libmbedtls);

	/**
	 * ʽñ̬ mbedtls ̬
	 * @return {bool} Ƿɹ
	 */
	static bool load(void);

public:
	// @override sslbase_conf
	sslbase_io* create(bool nblock);

private:
	friend class mbedtls_io;

	unsigned init_status_;
	unsigned cert_status_;
	thread_mutex lock_;

	bool  server_side_;

	void* conf_;
	void* entropy_;
	void* rnd_;
	void* cacert_;
	string crt_file_;
	void* cache_;
	mbedtls_verify_t verify_mode_;
	std::vector<std::pair<void*, void*> > cert_keys_;

private:
	bool init_once(void);
	bool init_rand(void);
	void free_ca(void);
};

} // namespace acl
