#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/pipe_stream.hpp"
#include "stream.hpp"

struct iovec;

namespace acl {

class string;

/**
 * ࣬ȷ֪ǷǷرգ
 * Ӧõ stream->eof() ж
 */

class ACL_CPP_API ostream : virtual public stream , public pipe_stream {
public:
	ostream(void) {}
	virtual ~ostream(void) {}

	/**
	 * д
	 * @param data {const void*} ַָ
	 * @param size {size_t} data ݳ(ֽ)
	 * @param loop {bool} Ƿ֤ȫŷأΪ true,
	 *  úֱȫŻ᷵أдһα㷵أ
	 *  ֤ȫд
	 * @param buffed {bool} ǷȻд
	 * @return {int} ʵд,  -1 ʾ
	 */
	int write(const void* data, size_t size, bool loop = true,
		bool buffed = false);

	/**
	 * ñķʽʱɵñĿַݰ
	 * @param data {const void*} ݵַ
	 * @param size {size_t} ݳ
	 * @param dest_addr {const char*} Ŀַʽip|port
	 * @param flags {int} ͱ־λοϵͳ sendto() api  flags ˵
	 * @return {int}  -1 ʾʧ
	 */
	int sendto(const void* data, size_t size,
		const char* dest_addr, int flags = 0);

	/**
	 * ñķʽʱɵñĿַݰ
	 * @param data {const void*} ݵַ
	 * @param size {size_t} ݳ
	 * @param dest_addr {const sockaddr*} Ŀַʽip|port
	 * @param addrlen {int} dest_addr ַ
	 * @param flags {int} ͱ־λοϵͳ sendto() api  flags ˵
	 * @return {int}  -1 ʾʧ
	 */
	int sendto(const void* data, size_t size,
		const struct sockaddr* dest_addr, int addrlen, int flags = 0);

	/**
	 * д巽ʽҪñˢд
	 * @return {bool}  false ʾдʧܣпӹر
	 */
	bool fflush(void);

	/**
	 * д
	 * @param v {const struct iovec*}
	 * @param count {int}  v Ԫظ
	 * @param loop {bool} Ƿ֤ȫŷأΪ true
	 *  úֱȫŻ᷵أдһα㷵أ
	 *  ֤ȫд
	 * @return {int} ʵд,  -1 ʾ
	 */
	int writev(const struct iovec *v, int count, bool loop = true);

	/**
	 * ʽʽдݣ vfprintf֤ȫд
	 * @param fmt {const char*} ʽַ
	 * @param ap {va_list} б
	 * @return {int} ʵдݳȣ -1 ʾ
	 */
	int vformat(const char* fmt, va_list ap);

	/**
	 * ʽʽдݣ fprintf֤ȫд
	 * @param fmt {const char*} θʽַ
	 * @return {int} ʵдݳȣ -1 ʾ
	 */
	int format(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * дһ 64 λ
	 * @param n {acl_int64} 64 λ
	 * @return {int} дݳȣ -1 ʾ
	 */
#if defined(_WIN32) || defined(_WIN64)
	int write(__int64 n);
#else
	int write(long long int n);
#endif

	/**
	 * дһ 32 λ
	 * @param n {int} 32 λ
	 * @return {int} дݳȣ -1 ʾ
	 */
	int write(int n);

	/**
	 * дһ 16 λ
	 * @param n {int} 16 λ
	 * @return {int} дݳȣ -1 ʾ
	 */
	int write(short n);

	/**
	 * дһֽ
	 * @param ch {char}
	 * @return {int} дݳȣ -1 ʾ
	 */
	int write(char ch);

	/**
	 * е
	 * @param s {const string&}
	 * @param loop {bool} ǷҪȫŷ
	 * @return {int} ݵĳȣ -1 ʾ
	 */
	int write(const string& s, bool loop = true);

	/**
	 * һַݣַ "\r\n"
	 * @param s {const char*} ַָ룬 '\0' β
	 * @return {int} ݵĳȣ -1 ʾ
	 */
	int puts(const char* s);

	/**
	 * ¼ΪغҶ̣
	 * жǷرӦõ stream->eof()
	 * ж
	 */

	ostream& operator<<(const string& s);
	ostream& operator<<(const char* s);
#if defined(_WIN32) || defined(_WIN64)
	ostream& operator<<(__int64 n);
#else
	ostream& operator<<(long long int n);
#endif
	ostream& operator<<(int n);
	ostream& operator<<(short n);
	ostream& operator<<(char ch);

	// pipe_stream 麯
	// ΪԽʵһ
	virtual int push_pop(const char* in, size_t len,
		string* out = NULL, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0)
	{
		(void) out;
		(void) max;
		return (0);
	}

protected:
private:
};

} // namespace acl
