#pragma once
#include "../acl_cpp_define.hpp"
#include "sslbase_io.hpp"

struct ACL_VSTREAM;

namespace acl {

class polarssl_conf;

/**
 * stream/aio_stream ײ IO ̵Ĵ࣬еĶдĹ̽
 * stream/aio_stream  Ĭϵĵײ IO ̣Ƕ̬(ΪѶ)
 * stream/aio_stream ͨñ destroy()ͷű
 */
class ACL_CPP_API polarssl_io : public sslbase_io {
public:
	/**
	 * 캯
	 * @param conf {polarssl_conf&} ÿһ SSL ӽõ
	 * @param server_side {bool} ǷΪģʽΪͻģʽ
	 *  ģʽַͬͨ˲
	 * @param nblock {bool} ǷΪģʽ
	 */
	polarssl_io(polarssl_conf& conf, bool server_side, bool nblock = false);

	/**
	 * @override stream_hook
	 *  SSL IO 
	 */
	void destroy(void);

	/**
	 * @override sslbase_io
	 * ô˷ SSL ֣ڷ IO ģʽ¸úҪ handshake_ok()
	 * ʹж SSL Ƿɹ
	 * @return {bool}
	 *  1 false ʾʧܣҪرӣ
	 *  2 true ʱ
	 *  2.1Ϊ IO ģʽʾ SSL ֳɹ
	 *  2.2ڷ IO ģʽ½ֹ IO ǳɹģҪ
	 *       handshake_ok() ж SSL Ƿɹ
	 */
	bool handshake(void);

	/**
	 * Է֤ǷЧһ㲻صô˺
	 * @return {bool}
	 */
	bool check_peer(void);

protected:
	~polarssl_io(void);

	// ʵ stream_hook 鷽

	// @override stream_hook
	bool open(ACL_VSTREAM* s);

	// @override stream_hook
	bool on_close(bool alive);

	// @override stream_hook
	int read(void* buf, size_t len);

	// @override stream_hook
	int send(const void* buf, size_t len);

private:
	polarssl_conf& conf_;
	void* ssl_;
	void* ssn_;
	void* rnd_;

private:
	static int sock_read(void *ctx, unsigned char *buf, size_t len);
	static int sock_send(void *ctx, const unsigned char *buf, size_t len);
};

} // namespace acl
