#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/string.hpp"
#include "../stdlib/noncopyable.hpp"
#if defined(_WIN32) || defined(_WIN64)
#include <WinSock2.h>
#endif

namespace acl {

class socket_stream;

enum {
	OPEN_FLAG_NONE      = 0,
	OPEN_FLAG_NONBLOCK  = 1,	// ģʽ
	OPEN_FLAG_REUSEPORT = 1 << 1,	// ˿ڸãҪ Linux3.0 
	OPEN_FLAG_FASTOPEN  = 1 << 2,	// Ƿ Fast openʵ׶Σ
	OPEN_FLAG_EXCLUSIVE = 1 << 3,	// Ƿֹõַ
};

/**
 * ˼׽ӿ࣬տͻӣͻӶ
 */
class ACL_CPP_API server_socket : public noncopyable {
public:
#if 0
	/**
	 * 캯ñ캯෽ open ַָ
	 * @param backlog {int} ׽ӿڶг
	 * @param block {bool} ģʽǷģʽ
	 */
	server_socket(int backlog, bool block);
#endif

	/**
	 * 캯
	 * @param flag {unsigned} μ OPEN_FLAG_XXX
	 * @param backlog {int} ׽ӿڶг
	 */
	server_socket(unsigned flag, int backlog);

	/**
	 * 캯ñ캯ֹٵ open 
	 * @param sstream {ACL_VSTREAM*} ⲿļ󣬱ʹ
	 *  ͷţӦйرոü
	 */
	server_socket(ACL_VSTREAM* sstream);

	/**
	 * 캯ñ캯ֹٵ open 
	 * @param fd {ACL_SOCKET} ⲿļʹõͷţ
	 *  Ӧйرոü
	 */
#if defined(_WIN32) || defined(_WIN64)
	server_socket(SOCKET fd);
#else
	server_socket(int fd);
#endif

	server_socket(void);
	~server_socket(void);

	/**
	 * ʼ˵ַ
	 * @param addr {const char*} ַʽΪ
	 *  ip:port unix £׽ӿڣʽΪ/path/xxx
	 *  Linux ƽ̨£׽ӿڵַΪ@xxx ʽһĸΪ @ 
	 *  ڲԶ Linux µĳ׽ַʽabstract unix socket
	 * @return {bool} Ƿɹ
	 */
	bool open(const char* addr);

	/**
	 * жϵǰ׽ӿǷ
	 * @return {bool}
	 */
	bool opened(void) const;

	/**
	 * رѾ򿪵ļ׽ӿ
	 * @return {bool} Ƿر
	 */
	bool close(void);

	/**
	 * ׽ӿڴӷн
	 * @return {SOCKET} رľ
	 */
#if defined(_WIN32) || defined(_WIN64)
	SOCKET unbind(void);
#else
	int unbind(void);
#endif

	/**
	 * տͻӲͻ
	 * @param timeout {int} ֵ >= 0 ʱóʱʽտͻӣ
	 *  ָʱδÿͻӣ򷵻 NULL
	 * @param etimed {bool*} ָ NULL ʱʱ¸ú
	 *  NULLֵΪ true
	 * @return {socket_stream*} ؿձʾʧܻʱ
	 */
	socket_stream* accept(int timeout = -1, bool* etimed = NULL);

	/**
	 * üĵַ
	 * @return {const char*} ֵǿָ
	 */
	const char* get_addr(void) const
	{
		return addr_.c_str();
	}

	/**
	 * ַñԻü׽ӿ
	 * @return {int}
	 */
#if defined(_WIN32) || defined(_WIN64)
	SOCKET sock_handle(void) const
#else
	int sock_handle(void) const
#endif
	{
		return fd_;
	}

	/**
	 * ü׽ֵӳٽչܣͻʱŽӷ
	 * ӦãĿǰù֧ܽ Linux
	 * @param timeout {int} ͻڹ涨ʱδݣ
	 *  ҲӷظӦ
	 */
	void set_tcp_defer_accept(int timeout);

private:
	int      backlog_;
	unsigned open_flag_;
	bool     unix_sock_;
	string   addr_;

#if defined(_WIN32) || defined(_WIN64)
	SOCKET fd_;
	SOCKET fd_local_;
#else
	int   fd_;
	int   fd_local_;
#endif
};

} // namespace acl
