#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"

namespace acl {

class sslbase_io;

class ACL_CPP_API sslbase_conf : public noncopyable {
public:
	sslbase_conf(void) {}
	virtual ~sslbase_conf(void) {}

	/**
	 * 鷽 SSL IO 
	 * @param nblock {bool} ǷΪģʽ
	 * @return {sslbase_io*}
	 */
	virtual sslbase_io* create(bool nblock) = 0;

public:
	/**
	 *  CA ֤(ÿʵֻһα)
	 * @param ca_file {const char*} CA ֤ļȫ·
	 * @param ca_path {const char*}  CA ֤ļĿ¼
	 * @return {bool}   CA ֤Ƿɹ
	 * ע ca_fileca_path ǿգμ֤
	 */
	virtual bool load_ca(const char* ca_file, const char* ca_path)
	{
		(void) ca_file;
		(void) ca_path;
		return false;
	}

	/**
	 * һ/ͻԼ֤飬Զεñض֤
	 * @param crt_file {const char*} ֤ļȫ·ǿ
	 * @param key_file {const char*} Կļȫ·ǿ
	 * @param key_pass {const char*} Կļ룬ûԿд NULL
	 * @return {bool} ֤Ƿɹ
	 */
	virtual bool add_cert(const char* crt_file, const char* key_file,
		const char* key_pass = NULL)
	{
		(void) crt_file;
		(void) key_file;
		(void) key_pass;
		return false;
	}

	/**
	 * һ/ͻԼ֤飬Զεñض֤
	 * @param crt_file {const char*} ֤ļȫ·ǿ
	 * @return {bool} ֤Ƿɹ
	 * @deprecated use add_cert(const char*, const char*, const char*)
	 */
	virtual bool add_cert(const char* crt_file)
	{
		(void) crt_file;
		return false;
	}

	/**
	 * ӷ/ͻ˵Կ(ÿʵֻһα)
	 * @param key_file {const char*} Կļȫ·ǿ
	 * @param key_pass {const char*} Կļ룬ûԿд NULL
	 * @return {bool} Ƿɹ
	 * @deprecated use add_cert(const char*, const char*, const char*)
	 */
	virtual bool set_key(const char* key_file, const char* key_pass = NULL)
	{
		(void) key_file;
		(void) key_pass;
		return false;
	}

	/**
	 * ΪģʽʱǷûỰ湦ܣ SSL Ч
	 * @param on {bool}
	 * עúԷģʽЧ
	 */
	virtual void enable_cache(bool on)
	{
		(void) on;
	}
};

} // namespace acl
