#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stream/aio_socket_stream.hpp"

struct ACL_VSTREAM;

namespace acl
{

class ACL_CPP_API ssl_aio_stream
	: public aio_socket_stream
	, public aio_open_callback
{
public:
	/**
	 * 캯첽ͻ
	 * @param handle {aio_handle*} 첽
	 * @param stream {ACL_ASTREAM*} 
	 * @param opened {bool} ǷѾӣԶ
	 *  hook д̼ر/ʱ̣ hook ر/ʱ
	 * @param use_ssl {bool} Ƿʹ SSL ׽ӿ
	 */
	ssl_aio_stream(aio_handle* handle, ACL_ASTREAM* stream,
		bool opened = false, bool use_ssl = true);

	/**
	 * 캯첽ͻ hook д̼ر/ʱ
	 * @param handle {aio_handle*} 첽
	 * @param fd {ACL_SOCKET} ׽ӿھ
	 * @param use_ssl {bool} Ƿʹ SSL ׽ӿ
	 */
#ifdef	WIN32
	ssl_aio_stream(aio_handle* handle, SOCKET fd, bool use_ssl = true);
#else
	ssl_aio_stream(aio_handle* handle, int fd, bool use_ssl = true);
#endif

	/**
	 * Զ̷ӣԶ hook ĹرաʱԼӳɹ
	 * ʱĻص
	 * @param handle {aio_handle*} 첽
	 * @param addr {const char*} Զ̷ĵַַʽΪ
	 *  TCPIP:Port  ׽ӿڣ{filePath}
	 * @param timeout {int} ӳʱʱ()
	 * @param use_ssl {bool} Ƿʹ SSL ׽ӿ
	 * @return {bool} ʧú false
	 *  true ֻǱʾӹУǷʱǷʧ
	 *  Ӧͨصж
	 */
	static ssl_aio_stream* open(aio_handle* handle,
		const char* addr, int timeout, bool use_ssl = true);

	/**
	 * úѾ򿪵вڽΪ SSL ģʽ
	 *  SSL ģʽ
	 * @param on {bool} Ƿ SSL ģʽòΪ false ʱ
	 *  ǰѾ SSL ģʽر SSL ģʽǰΪ SSL
	 *  ģʽֱӷأòΪ true ʱǰѾ SSL
	 *  ģʽֱӷأǰΪ SSL ģʽ SSL ģʽ
	 * @return {bool}
	 */
	bool open_ssl(bool on);

protected:
	virtual ~ssl_aio_stream();

	/**
	*  aio_open_callback ӿ
	*/
	virtual bool open_callback();
private:
	void* ssl_;
	void* ssn_;
	void* hs_;

	bool ssl_client_init();

	static int __sock_read(void *ctx, unsigned char *buf, size_t len);
	static int __sock_send(void *ctx, const unsigned char *buf, size_t len);

#ifdef WIN32
	static int __ssl_read(SOCKET fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int __ssl_send(SOCKET fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
#else
	static int __ssl_read(int fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int __ssl_send(int fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
#endif

	void clear(void);
};

} // namespace acl
