#ifndef __ARGV_INCLUDE_H__
#define __ARGV_INCLUDE_H__

# ifdef	__cplusplus
extern "C" {
# endif
#include <stdarg.h>
#include "iterator.h"

/**
 * External interface.
 */
typedef struct ARGV {
	int     len;			/**< number of array elements */
	int     argc;			/**< array elements in use */
	char  **argv;			/**< string array */

	/* Ӽ */

	/* βַ (ڲַ̬) */
	void  (*push_back)(struct ARGV*, const char*);
	/* ͷӶ̬ (ڲַ̬)*/
	void  (*push_front)(struct ARGV*, const char*);
	/* βַ ( myfree ͷ) */
	char *(*pop_back)(struct ARGV*);
	/* ͷַ ( myfree ͷ) */
	char *(*pop_front)(struct ARGV*);

	/* for iterator */

	/* ȡͷ */
	void *(*iter_head)(ITER*, struct ARGV*);
	/* ȡһ */
	void *(*iter_next)(ITER*, struct ARGV*);
	/* ȡβ */
	void *(*iter_tail)(ITER*, struct ARGV*);
	/* ȡһ */
	void *(*iter_prev)(ITER*, struct ARGV*);
} ARGV;

/* in argv.c */
/**
 * һַ̬
 * @param size {int} ̬ĳʼС
 * @return {ARGV*}
 */
ARGV *argv_alloc(int size);

/**
 * ַ̬һַһNULLַʾ
 * @param argvp {ARGV*} ַָ̬
 * @param ... ַбһΪNULL, ʽ磺{s1}, {s2}, ..., NULL
 */
void argv_add(ARGV *argvp,...);

/**
 * ַַ̬б
 * @param argvp {ARGV*} ַָ̬
 * @param ap {va_list} ɶַɵıб
 */
void argv_addv(ARGV *argvp, va_list ap);

/**
 * ͷַ̬
 * @param argvp {ARGV*} ַָ̬
 */
ARGV *argv_free(ARGV *argvp);

/**
 * ַ̬Ľλ
 * @param argvp {ACL_ARGV*} ַָ̬
 */
void argv_terminate(ARGV *argvp);

/**
 * صǰַ̬Ѿŵַ
 * @param argvp {ARGV*} ַָ̬
 * @return {int}
 */
int argv_size(ARGV *argvp);

/**
 * Դַַָһַ̬
 * @param str {const char*} Դַ
 * @param delim {const char*} ַָ
 * @return {ARGV*}
 */
ARGV *argv_split(const char *str, const char *delim);

#define ARGV_END	((char *) 0)

# ifdef	__cplusplus
}
# endif

#endif

