#ifndef ATOMIC_INCLUDE_H
#define ATOMIC_INCLUDE_H

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct ATOMIC ATOMIC;

/**
 * ԭӶ
 * @return {ATOMIC*} ´Ķ
 */
ATOMIC *atomic_new(void);

/**
 * ͷԭӶ
 * @param self {ATOMIC*} ԭӶ
 */
void atomic_free(ATOMIC *self);

/**
 * ָԭӶ󶨣ԱڶԸöԭӲ
 * @param self {ATOMIC*} ԭӶ
 * @param value {void*} ĶͨԭӶʵֶԸöԭӲ
 */
void atomic_set(ATOMIC *self, void *value);

/**
 * Ƚϲ󣬵ԭӶ󶨵ĶȽ϶ͬʱ¶
 * ֮ǰ󶨵Ķ
 * @param self {ATOMIC*} ԭӶ
 * @param cmp {void*} Ƚ϶ָ
 * @param value {void*} ԭӶȽ϶ͬʱὫöԭӶ
 * @return {void*} ԭӶ֮ǰ󶨵Ķ
 */
void *atomic_cas(ATOMIC *self, void *cmp, void *value);

/**
 * ԭӶ¶а󶨣֮ǰ󶨵Ķ
 * @param self {ATOMIC*} ԭӶ
 * @param value {void*} 󶨵¶
 * @return {void*} ֮ǰ󶨵Ķ
 */
void *atomic_xchg(ATOMIC *self, void *value);

/**
 *  atomic_set 󶨵ĶΪֵʱԵô˺ñ󶨶
 * ĳֵ
 * @param self {ATOMIC*} ԭӶ
 * @param n {long long} ԭӶ󶨵Ķ󽫱ֵΪֵ
 */
void atomic_int64_set(ATOMIC *self, long long n);

/**
 * Ȼֵ洢ֵȻֵָ洢ڸֵ
 * @param self {ATOMIC*} ԭӶ
 * @param n {long long} ֵ 
 * @return {long long} ֮ǰֵֵ
 */
long long atomic_int64_fetch_add(ATOMIC *self, long long n);

/**
 * ݶ洢ֵֵָؽֵ
 * @param self {ATOMIC*} ԭӶ
 * @param n {long long} ֵ 
 * @return {long long} ֵ֮
 */
long long atomic_int64_add_fetch(ATOMIC *self, long long n);

/**
 * ȽϲֵԭӶ洢ֵȽֵͬʱ
 * ֵҷ֮ǰ洢ֵ
 * @param self {ATOMIC*} ԭӶ
 * @param cmp {long long} Ƚֵ
 * @param n {long long} ԭӶȽֵͬʱὫԭӶΪֵ
 * @return {long long} ԭӶ֮ǰ洢ֵ
 */
long long atomic_int64_cas(ATOMIC *self, long long cmp, long long n);

#ifdef __cplusplus
}
#endif

#endif
