#ifndef _MBOX_INCLUDE_H
#define _MBOX_INCLUDE_H

typedef struct MBOX MBOX;

#define	MBOX_T_SPSC		0	/* ߵ */
#define	MBOX_T_MPSC		1	/* ߵ */

/**
 * Ϣж
 * @param type {unsigned}
 * @return {MBOX}
 */
MBOX *mbox_create(unsigned type);

/**
 * ͷϢж
 * @param mbox {MBOX*} Ϣж
 * @param free_fn {void (*)(void*)} ǿʱͷŵǰϢеĶ
 */
void mbox_free(MBOX *mbox, void (*free_fn)(void*));

/**
 * ϢӶ̬Ϣ
 * @param mbox {MBOX*} Ϣж
 * @param msg {void*}
 * @return {int} ͳɹ 0򷵻 -1
 */
int mbox_send(MBOX *mbox, void *msg);

/**
 * ϢжȡϢ
 * @param mbox {MBOX*} Ϣж
 * @param timeout {int} ȴʱʱ(뼶) < 0 һֱȴֱ
 * @param success {int*} 洢ǷɹĽ 0 ʾ 0 ʾɹ
 * @return {void*} ضϢ NULL ʱж success ֵ
 *  Դж϶Ƿɹط NULL ʾɹһϢ
 */
void *mbox_read(MBOX *mbox, int timeout, int *success);

/**
 * õǰϢѾɹ͵Ϣ
 * @param mbox {MBOX*} Ϣж
 * @return {size_t}
 */
size_t mbox_nsend(MBOX *mbox);

/**
 * õǰϢѾɹյϢ
 * @param mbox {MBOX*} Ϣж
 * @return {size_t}
 */
size_t mbox_nread(MBOX *mbox);

socket_t mbox_in(MBOX *mbox);
socket_t mbox_out(MBOX *mbox);

#endif
