#ifndef	QUEUE_INCLUDE_H
#define	QUEUE_INCLUDE_H

#ifdef __linux

#ifdef __cplusplus
extern "C" {
#endif

#define	QUEUE_ERR_UNKNOWN      -1
#define	QUEUE_OK               0
#define	QUEUE_ERR_LOCK         1
#define	QUEUE_ERR_UNLOCK       2
#define	QUEUE_ERR_TIMEOUT      3
#define	QUEUE_ERR_COND_WAIT    4
#define	QUEUE_ERR_COND_SIGNALE 5

typedef struct QUEUE_ITEM QUEUE_ITEM;
typedef struct QUEUE QUEUE;

typedef void (*QUEUE_FREE_FN)(void *);

/**
 * һ¶ж
 * @return QUEUE ṹָ
 */
QUEUE *queue_new(void);

/**
 * ǷϸеߣĬΪҪиü queue_free
 * @param que QUEUE ṹָ
 * @param flag 
 */
void queue_check_owner(QUEUE *que, char flag);

/**
 * öе, ֻ߲ȨͷŶ,  queue_free()
 * @param que QUEUE ṹָ
 * @param owner ̺߳űʶߵID
 */
void queue_set_owner(QUEUE *que, unsigned int owner);

/**
 * ͷŶж
 * @param que QUEUE ṹָ
 * @param free_fn ͷŶʱ, úΪ, ڲͨ˺е
 *        ûעݶнͷ
 */
void queue_free(QUEUE *que, QUEUE_FREE_FN free_fn);

/**
 * ӶȡһԪ, ʱ, һֱȵԪؿû
 * @param que QUEUE ṹָ
 * @return ûͨ queue_push Ԫָ
 */
void *queue_pop(QUEUE *que);

/**
 * ӶȡһԪ, ʱ, һֱȵԪؿûʱ
 * @param que QUEUE ṹָ
 * @param tmo_sec ӶȡԪصĳʱʱ, λΪ
 * @param tmo_usec ӶȡԪصĳʱʱ, λΪ΢
 * @return ûͨ queue_push Ԫָ
 */
 void *queue_pop_timedwait(QUEUE *que, int tmo_sec, int tmo_usec);

/**
 * һԪ
 * @param que QUEUE ṹָ
 * @param data ûָ
 * @return {int} ӶԪǷɹ, 0: ok; < 0: error
 */
 int queue_push(QUEUE *que, void *data);

/**
 * һζвĴ, define as: QUEUE_XXX
 * @param que QUEUE ṹָ
 * @return 
 */
 int queue_last_error(const QUEUE *que);

/**
 * öΪ˳״̬
 * @param que QUEUE ṹָ
 */
 void queue_set_quit(QUEUE *que);

/**
 * õǰжԪصĸ
 * @param que {QUEUE*}
 * @return {int} Ԫظ< 0 ʾ
 */
 int queue_qlen(QUEUE* que);

#ifdef __cplusplus
}
#endif

#endif // __linux__

#endif

