#pragma once
#include <stddef.h>
#include <string>
#include <vector>
#include "fiber_cpp_define.hpp"

struct ACL_FIBER;

namespace acl {

typedef enum 
{
	FIBER_EVENT_T_KERNEL,	// Linux: epoll, FreeBSD: kquque, Windows: iocp
	FIBER_EVENT_T_POLL,	// Linux, FreeBSD, MacOS, Windows
	FIBER_EVENT_T_SELECT,	// Linux, FreeBSD, MacOS, Windows
	FIBER_EVENT_T_WMSG,	// Windows
	FIBER_EVENT_T_IO_URING,	// Linux
} fiber_event_t;

struct FIBER_CPP_API fiber_frame
{
	fiber_frame(void) : pc(0), off(0) {}
	~fiber_frame(void) {}

	std::string func;
	long pc;
	long off;
};

/**
 * Эඨ壬࣬Ҫ̳вʵִ鷽
 */
class FIBER_CPP_API fiber
{
public:
	fiber(void);
	fiber(ACL_FIBER *fb);

	/**
	 * 캯
	 * @param running {bool} Ϊ true ʱʾǰЭ
	 *  һЭ̶ѣԱ ACL_FIBER 󶨣ʱֹñ
	 *   start Э; Ϊ false ʱҪ start 
	 *  Э
	 */
	fiber(bool running);

	virtual ~fiber(void);

	/**
	 * ڴһЭҹ running Ϊ false ʱҪ
	 * Э̣Ȼص run ص running Ϊ true ʱ
	 * ֹ start 
	 * @param stack_size {size_t} Э̶ջС
	 * @param share_stack {bool} Ƿùջʽ(Ҫùջʽ
	 *  ڱ libfiber.a ʱ뿪 SHARE_STACK )
	 */
	void start(size_t stack_size = 320000, bool share_stack = false);

	/**
	 * ڱЭʱô˺֪ͨЭ˳
	 * @return {bool}  false ʾЭδѾ˳
	 */
	bool kill(void);

	/**
	 * жϵǰЭǷ֪ͨ˳
	 * @return {bool} ЭǷ֪ͨ˳
	 */
	bool killed(void) const;

	/**
	 * жϵǰеЭǷ֪ͨ˳÷ killed Ϊ
	 * killed ȱ acl::fiber УҸЭ̶пУ
	 * Ҳпܱ𣬶 self_killed Ҫ acl::fiber һʾ
	 * ǰеЭ
	 * @return {bool}
	 */
	static bool self_killed(void);

	/**
	 * ñЭ̶ ID 
	 * @return {unsigned int}
	 */
	unsigned int get_id(void) const;

	/**
	 * õǰеЭ̶ ID 
	 * @return {unsigned int}
	 */
	static unsigned int self(void);

	/**
	 * ָЭ̶ID
	 * @return {unsigned int}
	 */
	static unsigned int fiber_id(const fiber& fb);

	/**
	 * õǰЭִĳϵͳ API ʱĴ
	 * return {int}
	 */
	int get_errno(void) const;

	/**
	 * õǰЭ̵Ĵ
	 * @param errnum {int}
	 */
	void set_errno(int errnum);

public:
	/**
	 * ñβĳϢ
	 * @return {const char*}
	 */
	static const char* last_serror(void);

	/**
	 * ñβĳ
	 * @return {int}
	 */
	static int last_error(void);

	/**
	 * תϢ
	 * @param errnum {int} 
	 * @param buf {char*} 洢
	 * @param size {size_t} buf ռС
	 * @return {const char*} buf ַ
	 */
	static const char* strerror(int errnum, char* buf, size_t size);

	/**
	 * Ϣ׼
	 * @param on {bool} Ϊ true ʱڲϢ׼
	 */
	static void stdout_open(bool on);

	/**
	 * ʽЭ̵¼ͣͬʱЭ̵Ϊģʽ
	 * Э̺󲻱ʽ schedule  schedule_with Э̵
	 * @param type {fiber_event_t} ¼ͣμFIBER_EVENT_T_XXX
	 * @param schedule_auto {bool} Ϊ true򴴽Э̶иЭ
	 *  󲻱ʽ schedule/schedule_with еЭ̹̣
	 *  ԶЭ̵ڴЭ̺󣬱ʽص
	 *  schedule  schedule_with ʽЭ̵Э̹̣
	 *  ڲȱʡ״̬Ϊ false
	 */
	static void init(fiber_event_t type, bool schedule_auto = false);

	/**
	 * Эеĵȹ
	 */
	static void schedule(void);

	/**
	 * Э̵ʱָ¼ͣñͬʱ schedule_init
	 *  schedule 
	 * @param type {fiber_event_t} ¼ͣμFIBER_EVENT_T_XXX
	 */
	static void schedule_with(fiber_event_t type);

	/**
	 * жϵǰ߳ǷЭ̵״̬
	 * @return {bool}
	 */
	static bool scheduled(void);

	/**
	 *  ֹͣЭ̵ȹ
	 */
	static void schedule_stop(void);

public:
	/**
	 * ǰеЭ(Э) 
	 */
	static void yield(void);

	/**
	 * ǰЭִ̣еȴеһЭ
	 */
	static void switch_to_next(void);

	/**
	 * ָЭ̶ж
	 * @param f {fiber&}
	 */
	static void ready(fiber& f);

	/**
	 * ʹǰеЭָ
	 * @param milliseconds {unsigned int} ָҪߵĺ
	 * @return {unsigned int} ЭߺٴαѺʣĺ
	 */
	static unsigned int delay(unsigned int milliseconds);

	/**
	 * ôڴ״̬Э
	 * @return {unsigned}
	 */
	static unsigned alive_number(void);

	/**
	 * ô˳״̬Э̶
	 * @return {unsigned}
	 */
	static unsigned dead_number(void);

	/**
	 * ñ߳Эӷʱ˴ʱķʽWindows)
	 * @param yes {bool}
	 */
	static void set_non_blocking(bool yes);

	/**
	 * ùջģʽùջĴС,ڲȱʡֵΪ 1024000 ֽ
	 * @param size {size_t} ջڴС
	 */
	static void set_shared_stack_size(size_t size);

	/**
	 * ùջģʽ»ùջС
	 * @return {size_t}  0 ʾδùջʽ
	 */
	static size_t get_shared_stack_size(void);

	/**
	 * ʽñʹ acl  IO Э̻ UNIX ƽ̨²ʽ
	 * ñΪڲԶ HOOK IO API
	 */
	static void acl_io_hook(void);

	/**
	 * ñȡ aclе IO Э̻
	 */
	static void acl_io_unlock(void);

	/**
	 * Windows ƽ̨¿ʽصô˺ Hook һЩЭصϵͳ API
	 * @return {bool}
	 */
	static bool winapi_hook(void);

	/**
	 * õǰϵͳ
	 * @return {int}
	 */
	static int  get_sys_errno(void);

	/**
	 * õǰϵͳ
	 * @param errnum {int}
	 */
	static void set_sys_errno(int errnum);

public:
	/**
	 * رЭ̶Ӧ C ԵЭ̶
	 * @return {ACL_FIBER* }
	 */
	ACL_FIBER* get_fiber(void) const;

	/**
	 * ײ C API Э
	 * @param fn {void (*)(ACL_FIBER*, void*)} Эִ̺
	 * @param ctx {void*} ݸЭִкĲ
	 * @param size {size_t} ЭջС
	 */
	static void fiber_create(void (*fn)(ACL_FIBER*, void*),
			void* ctx, size_t size);

	/**
	 * ָЭ̵Ķջ
	 * @param fb {const fiber&}
	 * @param out {std::vector<stack_frame>&} Ž
	 * @param max {size_t} ָȡջ
	 */
	static void stacktrace(const fiber& fb, std::vector<fiber_frame>& out,
			size_t max = 50);

protected:
	/**
	 * 麯ʵֱͨ start Э̺󣬱
	 * 麯ᱻãӶ֪ͨЭ; ڹ캯еĲ
	 * running Ϊ true  start ֹãʱ鷽Ҳᱻ
	 */
	virtual void run(void);

private:
	ACL_FIBER* f_;

	fiber(const fiber&);
	void operator = (const fiber&);

	static void fiber_callback(ACL_FIBER* f, void* ctx);
};

/**
 * ʱЭ
 */
class FIBER_CPP_API fiber_timer
{
public:
	fiber_timer(void);
	virtual ~fiber_timer(void) {}

	/**
	 * һЭ̶ʱ
	 * @param milliseconds {unsigned int} 뼶ʱ
	 * @param stack_size {size_t} Э̵ջռС
	 */
	void start(unsigned int milliseconds, size_t stack_size = 320000);

protected:
	/**
	 * ʵָô鷽ʱʱص÷
	 */
	virtual void run(void) = 0;

private:
	ACL_FIBER* f_;

	fiber_timer(const fiber_timer&);
	void operator = (const fiber_timer&);

	static void timer_callback(ACL_FIBER* f, void* ctx);
};

#if defined(ACL_CPP_API)

/**
 * ʱЭ
 */
template <typename T>
class fiber_trigger : public fiber
{
public:
	fiber_trigger(timer_trigger<T>& timer)
	: delay_(100)
	, stop_(false)
	, timer_(timer)
	{
	}

	virtual ~fiber_trigger(void) {}

	void add(T* o)
	{
		mbox_.push(o);
	}

	void del(T* o)
	{
		timer_.del(o);
	}

	timer_trigger<T>& get_trigger(void)
	{
		return timer_;
	}

	// @override
	void run(void)
	{
		while (!stop_) {
			T* o = mbox_.pop(delay_);
			if (o)
				timer_.add(o);

			long long next = timer_.trigger();
			long long curr = get_curr_stamp();
			if (next == -1)
				delay_ = 100;
			else {
				delay_ = next - curr;
				if (delay_ <= 0)
					delay_ = 1;
			}
		}
	}

private:
	long long delay_;
	bool stop_;

	timer_trigger<T>& timer_;
	mbox<T> mbox_;
};

#endif // ACL_CPP_API

} // namespace acl
