#pragma once
#include <vector>
#include "fiber_cpp_define.hpp"
#include "fiber_mutex_stat.hpp"

struct ACL_FIBER_MUTEX;

namespace acl {

/**
 * ͬһ߳ڵЭ֮Լ֮ͬ߳Э֮Ļ, ͬʱ
 * ֮߳ԼЭ֮߳Ļ.
 */
class FIBER_CPP_API fiber_mutex
{
public:
	/**
	 * 캯
	 * @param mutex {ACL_FIBER_MUTEX*} ǿʱ, C 󴴽 C++ 
	 *  ,ڲԶ C ;ǿʱ,ڱʱô
	 *  C Ӧòͷ.
	 */
	fiber_mutex(ACL_FIBER_MUTEX* mutex = NULL);
	~fiber_mutex(void);

	/**
	 * ȴ
	 * @return {bool}  true ʾɹʾڲ
	 */
	bool lock(void);

	/**
	 * Եȴ
	 * @return {bool}  true ʾɹʾڱռ
	 */
	bool trylock(void);

	/**
	 * ӵͷ֪ͨȴ
	 * @return {bool}  true ʾ֪ͨɹʾڲ
	 */
	bool unlock(void);

public:
	/**
	 *  C 汾Ļ
	 * @return {ACL_FIBER_MUTEX*}
	 */
	ACL_FIBER_MUTEX* get_mutex(void) const
	{
		return mutex_;
	}

	/**
	 * ȫ
	 * @param out {fiber_mutex_stats&} 洢
	 * @return {bool}  true ʾ, Ϣ out 
	 */
	static bool deadlock(fiber_mutex_stats& out);

private:
	ACL_FIBER_MUTEX* mutex_;
	ACL_FIBER_MUTEX* mutex_internal_;

	fiber_mutex(const fiber_mutex&);
	void operator=(const fiber_mutex&);
};

class FIBER_CPP_API fiber_mutex_guard
{
public:
	fiber_mutex_guard(fiber_mutex& mutex) : mutex_(mutex) {
		mutex_.lock();
	}

	~fiber_mutex_guard(void) {
		mutex_.unlock();
	}

private:
	fiber_mutex& mutex_;

};

} // namespace acl
