#pragma once
#include "fiber_cpp_define.hpp"
#include <list>
#include <stdlib.h>
#include "fiber_mutex.hpp"
#include "fiber_cond.hpp"

namespace acl {

/**
 * Э֮䣬֮߳ԼЭ֮߳ϢͨţͨЭ
 * Э¼ʵ
 *
 * ʾ
 *
 * class myobj {
 * public:
 *     myobj(void) {}
 *     ~myobj(void) {}
 *
 *     void test(void) { printf("hello world\r\n"); }
 * };
 *
 * acl::fiber_tbox<myobj> fiber_tbox;
 *
 * void thread_producer(void)
 * {
 *     myobj* o = new myobj;
 *     fiber_tbox.push(o);
 * }
 *
 * void thread_consumer(void)
 * {
 *     myobj* o = fiber_tbox.pop();
 *     o->test();
 *     delete o;
 * }
 */

// The base box<T> defined in acl_cpp/stdlib/box.hpp, so you must include
// box.hpp first before including fiber_tbox.hpp
template<typename T>
class fiber_tbox : public box<T> {
public:
	/**
	 * 췽
	 * @param free_obj {bool}  fiber_tbox ʱǷԶ鲢ͷ
	 *  δѵĶ̬
	 */
	fiber_tbox(bool free_obj = true) : size_(0), free_obj_(free_obj) {}

	~fiber_tbox(void)
	{
		clear(free_obj_);
	}

	/**
	 * ϢδѵϢ
	 * @param free_obj {bool} ͷŵ delete ɾϢ
	 */
	void clear(bool free_obj = false)
	{
		if (free_obj) {
			for (typename std::list<T*>::iterator it =
				tbox_.begin(); it != tbox_.end(); ++it) {

				delete *it;
			}
		}
		tbox_.clear();
	}

	/**
	 * Ϣ
	 * @param t {T*} ǿϢ
	 * @param notify_first {bool} Ϊ trueڲϢ
	 *  ֪ͨʽȽ֪ͨʽ fiber_tbox 
	 *  ڱȽϳʱòΪ false Чʸߣ fiber_tbox
	 *  ڽ϶(磺ȴߵ pop ֱ fiber_tbox ),
	 *  򱾲ӦΪ trueԱ push ߻ûȫǰ fiber_tbox
	 *  ǰٶڴǷ
	 * @return {bool}
	 * @override
	 */
	bool push(T* t, bool notify_first = true)
	{
		// ȼ
		if (mutex_.lock() == false) {
			abort();
		}

		// Ϣ
		tbox_.push_back(t);
		size_++;

		if (notify_first) {
			if (cond_.notify() == false) {
				abort();
			}
			if (mutex_.unlock() == false) {
				abort();
			}
			return true;
		} else {
			if (mutex_.unlock() == false) {
				abort();
			}
			if (cond_.notify() == false) {
				abort();
			}
			return true;
		}
	}

	/**
	 * Ϣ
	 * @param wait_ms {int} >= 0 ʱõȴʱʱ(뼶)
	 *  ԶȴֱϢ
	 * @param found {bool*} ǿʱǷһϢҪ
	 *  ݿնʱļ
	 * @return {T*}  NULL ʾһϢ󣬷 NULL ʱҪһ
	 *  飬 push һնNULLҲ NULL
	 *  ʱȻΪһϢֻΪն wait_ms 
	 *  Ϊ -1 ʱ NULL ȻΪһϢ wait_ms 
	 *   0 ʱ NULLӦü found ֵΪ true  false 
	 *  жǷһϢ
	 * @override
	 */
	T* pop(int wait_ms = -1, bool* found = NULL)
	{
		bool found_flag;
		if (mutex_.lock() == false) {
			abort();
		}
		while (true) {
			T* t = peek(found_flag);
			if (found_flag) {
				if (mutex_.unlock() == false) {
					abort();
				}
				if (found) {
					*found = found_flag;
				}
				return t;
			}

			// ע˳򣬱ȵ wait ж wait_ms
			if (!cond_.wait(mutex_, wait_ms) && wait_ms >= 0) {
				if (mutex_.unlock() == false) {
					abort();
				}
				if (found) {
					*found = false;
				}
				return NULL;
			}
		}
	}

	/**
	 * tbox пϢ
	 * @return {bool}
	 * @override
	 */
	bool has_null(void) const {
		return true;
	}

	/**
	 * صǰϢеϢ
	 * @return {size_t}
	 */
	size_t size(void) const
	{
		return size_;
	}

public:
	void lock(void)
	{
		if (mutex_.lock() == false) {
			abort();
		}
	}

	void unlock(void)
	{
		if (mutex_.unlock() == false) {
			abort();
		}
	}

private:
	fiber_tbox(const fiber_tbox&) {}
	const fiber_tbox& operator=(const fiber_tbox&);

private:
	std::list<T*> tbox_;
	size_t        size_;
	bool          free_obj_;
	fiber_mutex   mutex_;
	fiber_cond    cond_;

	T* peek(bool& found_flag)
	{
		typename std::list<T*>::iterator it = tbox_.begin();
		if (it == tbox_.end()) {
			found_flag = false;
			return NULL;
		}
		found_flag = true;
		size_--;
		T* t = *it;
		tbox_.erase(it);
		return t;
	}
};

} // namespace acl

