#include "stdafx.h"
#include "lib_acl.h" // just for getopt on Windows
#include <assert.h>
#include <iostream>
#include "acl_cpp/stdlib/util.hpp"
#include "acl_cpp/acl_cpp_init.hpp"
#include "acl_cpp/stdlib/log.hpp"
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/stream/aio_istream.hpp"
#include "acl_cpp/stream/aio_listen_stream.hpp"
#include "acl_cpp/stream/aio_socket_stream.hpp"

static int   __max = 0;
static int   __timeout = 0;

/**
 * ӳٶص
 */
class timer_reader: public acl::aio_timer_reader
{
public:
	timer_reader(int delay)
	{
		delay_ = delay;
		std::cout << "timer_reader init, delay: " << delay << std::endl;
	}

protected:
	~timer_reader(void) {}

	// aio_timer_reader  destroy 
	// @override
	void destroy(void)
	{
		std::cout << "timer_reader delete, delay: "  << delay_ << std::endl;
		delete this;
	}

	// ػص
	// @override
	void timer_callback(unsigned int id)
	{
		std::cout << "timer_reader(" << id
			<< "): timer_callback, delay: " << delay_ << std::endl;

		// ûĴ
		aio_timer_reader::timer_callback(id);
	}

private:
	int   delay_;
};

/**
 * ӳдص
 */
class timer_writer: public acl::aio_timer_writer
{
public:
	timer_writer(int delay)
	{
		delay_ = delay;
		std::cout << "timer_writer init, delay: " << delay << std::endl;
	}

protected:
	~timer_writer(void) {}

	// aio_timer_reader  destroy 
	// @override
	void destroy(void)
	{
		std::cout << "timer_writer delete, delay: " << delay_ << std::endl;
		delete this;
	}

	// ػص
	// @override
	void timer_callback(unsigned int id)
	{
		std::cout << "timer_writer(" << id << "): timer_callback, delay: "
			<< delay_ << std::endl;

		// ûĴ
		acl::aio_timer_writer::timer_callback(id);
	}

private:
	int   delay_;
};

/**
 * 첽ͻĻص
 */
class io_callback : public acl::aio_callback
{
public:
	io_callback(acl::aio_socket_stream* client)
	: client_(client)
	, i_(0) {}

protected:
	~io_callback(void)
	{
		std::cout << "delete io_callback now ..." << std::endl;
	}

	/**
	 * ʵָе麯ͻĶɹص
	 * @param data {char*} ݵַ
	 * @param len {int} ݳ
	 * @return {bool}  true ʾϣرո첽
	 */
	bool read_callback(char* data, int len)
	{
		i_++;
		if (i_ < 5) {
			std::cout << ">>gets(i:" << i_ << "): "
				<< data << std::endl;
		}

		// Զ̿ͻϣ˳ر֮
		if (strncasecmp(data, "quit", 4) == 0) {
			client_->format("Bye!\r\n");
			client_->close();
			return false;
		}

		// Զ̿ͻϣҲرգֹ첽¼
		else if (strncasecmp(data, "stop", 4) == 0) {
			client_->format("Stop now!\r\n");
			client_->close();  // رԶ첽

			// ֪ͨ첽رѭ
			client_->get_handle().stop();
		}

		// Զ̿ͻ˻дյ

		int   delay = 0;

		if (!strncasecmp(data, "write_delay", strlen("write_delay"))) {
			// ӳд

			const char* ptr = data + strlen("write_delay");
			delay = atoi(ptr);
			if (delay > 0) {
				std::cout << ">> write delay " << delay
					<< " second ..." << std::endl;
				timer_writer* timer = new timer_writer(delay);
				client_->write(data, len, delay * 1000000, timer);
				client_->gets(10, false);
				return true;
			}
		} else if (!strncasecmp(data, "read_delay", strlen("read_delay"))) {
			// ӳٶ

			const char* ptr = data + strlen("read_delay");
			delay = atoi(ptr);
			if (delay > 0) {
				client_->write(data, len);
				std::cout << ">> read delay " << delay
					<< " second ..." << std::endl;
				timer_reader* timer = new timer_reader(delay);
				client_->gets(10, false, delay * 1000000, timer);
				return true;
			}
		}

		client_->write(data, len);
		//client_->gets(10, false);
		return true;
	}

	/**
	 * ʵָе麯ͻдɹص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool write_callback(void)
	{
		return true;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 */
	void close_callback(void)
	{
		// ڴ˴ɾö̬ĻصԷֹڴй¶
		delete this;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool timeout_callback(void)
	{
		std::cout << "Timeout, delete it ..." << std::endl;
		return (false);
	}

private:
	acl::aio_socket_stream* client_;
	int  i_;
};

/**
 * 첽Ļص
 */
class io_accept_callback : public acl::aio_accept_callback
			 , public acl::aio_listen_callback
{
public:
	io_accept_callback(void) {}
	~io_accept_callback(void)
	{
		printf(">>io_accept_callback over!\n");
	}

	/**
	 *  aio_accept_callback 麯ӵô˻ص
	 * @param client {aio_socket_stream*} 첽ͻ
	 * @return {bool}  true ֪ͨ
	 */
	bool accept_callback(acl::aio_socket_stream* client)
	{
		printf("proactor accept one\r\n");
		return handle_client(client);
	}

	/**
	 *  aio_listen_callback 麯ӵô˻ص
	 * @param server {acl::aio_listen_stream&} 첽
	 * @return {bool}
	 */
	bool listen_callback(acl::aio_listen_stream& server)
	{
		// reactor ģʽҪûԼ accept 
		acl::aio_socket_stream* client = server.accept();
		if (client == NULL) {
			printf("accept error %s\r\n", acl::last_serror());
			return false;
		}

		printf("reactor accept one\r\n");
		return handle_client(client);
	}

private:
	bool handle_client(acl::aio_socket_stream* client)
	{
		// 첽ͻĻص첽а
		io_callback* callback = new io_callback(client);

		// ע첽Ķص
		client->add_read_callback(callback);

		// ע첽дص
		client->add_write_callback(callback);

		// ע첽Ĺرջص
		client->add_close_callback(callback);

		// ע첽ĳʱص
		client->add_timeout_callback(callback);

		// ޶󳤶ʱ
		if (__max > 0) {
			client->set_buf_max(__max);
		}

		// 첽һ
		client->gets(__timeout, false);
		return true;
	}
};

class mytimer : public acl::aio_timer_callback {
public:
	mytimer(long long delay) : id_(0), last_(time(NULL)), delay_(delay) {}
	~mytimer(void) {}

protected:
	// @override
	void destroy(void) {
		delete this;
	}

	// @override
	void timer_callback(unsigned int id) {
		time_t now = time(NULL);
		delay_ += 1000000;
		this->set_task(id_, delay_);

		printf("timer id=%u, delay=%ld, next delay=%lld\r\n",
			id, (long) (now - last_), delay_);

		last_ = now;
		id_ = id;
	}

private:
	unsigned int id_;
	time_t last_;
	long long delay_;
};

//#include <sys/epoll.h>

static void aio_run(bool use_reactor, acl::aio_handle& handle,
	acl::aio_listen_stream* sstream)
{
	// ص󣬵ӵʱԶôĻص
	io_accept_callback callback;

#if 0
	struct epoll_event event;
	int pfd = epoll_create(100);
	int epfd = fcntl(pfd, F_DUPFD_CLOEXEC, 0);
	printf(">>>epfd=%d, pfd=%d\n", epfd, pfd);
	event.events = EPOLLIN;
	event.data.ptr = sstream;
	int ret = epoll_ctl(epfd, EPOLL_CTL_ADD, sstream->sock_handle(), &event);
	printf(">>>epoll add ret=%d\n", ret);
	ret = epoll_ctl(epfd, EPOLL_CTL_DEL, sstream->sock_handle(), &event);
	printf(">>>epoll del ret=%d\n", ret);
#endif

	if (use_reactor) {
		sstream->add_listen_callback(&callback);
	} else {
		sstream->add_accept_callback(&callback);
	}

	printf("aio begin running ...\r\n");

	while (true) {
		//  false ʾټҪ˳
		if (!handle.check()) {
			std::cout << "aio_server stop now ..." << std::endl;
			break;
		}
	}

	// رռͷ
	sstream->close();

	// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
	handle.check();
}

static acl::aio_listen_stream* bind_addr(acl::aio_handle& handle,
	const acl::string& addr)
{
	// 첽
	acl::aio_listen_stream* sstream = new acl::aio_listen_stream(&handle);

	// ָĵַ
	if (!sstream->open(addr.c_str())) {
		std::cout << "open " << addr.c_str() << " error!" << std::endl;
		sstream->close();
		// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
		handle.check();

		getchar();
		return NULL;
	}

	std::cout << "Listen: " << addr.c_str() << " ok!" << std::endl;
	return sstream;
}

static void usage(const char* procname)
{
	printf("usage: %s -h[help]\r\n"
		"	-l ip:port\r\n"
		"	-L line_max_length\r\n"
		"	-t timeout\r\n"
		"	-r [use reactor mode other proactor mode, default: proactor mode]\r\n"
		"	-f [if use fiber mode]\r\n"
		"	-k[use kernel event: epoll/iocp/kqueue/devpool]\r\n",
		procname);
}

int main(int argc, char* argv[])
{
	bool use_kernel = false, use_reactor = false, use_fiber = false;
	int  ch;
	acl::string addr(":9001");

	while ((ch = getopt(argc, argv, "l:hkL:t:rf")) > 0) {
		switch (ch) {
		case 'h':
			usage(argv[0]);
			return 0;
		case 'l':
			addr = optarg;
			break;
		case 'k':
			use_kernel = true;
			break;
		case 'L':
			__max = atoi(optarg);
			break;
		case 't':
			__timeout = atoi(optarg);
			break;
		case 'r':
			use_reactor = true;
			break;
		case 'f':
			use_fiber = true;
			break;
		default:
			break;
		}
	}

	// ʼACL(WIN32һҪô˺UNIXƽ̨¿ɲ)
	acl::acl_cpp_init();

	acl::fiber::stdout_open(true);
	acl::log::stdout_open(true);


	if (use_fiber) {
		go[&] {
			// 첽
			acl::aio_handle handle(use_kernel ?
				acl::ENGINE_KERNEL : acl::ENGINE_SELECT);

			long long delay = 1000000;
			mytimer* timer = new mytimer(delay);
			timer->keep_timer(true);
			handle.set_timer(timer, delay);

			acl::aio_listen_stream* sstream = bind_addr(handle, addr);
			if (sstream) {
				printf(">>>begin run use fiber mode<<<\r\n");
				aio_run(use_reactor, std::ref(handle), sstream);
			}
		};

		go[=] {
			while (true) {
				sleep(2);
				printf("---wakeup---\r\n");
			}
		};

		acl::fiber::schedule();
	} else {
		acl::aio_handle handle(use_kernel ?
			acl::ENGINE_KERNEL : acl::ENGINE_SELECT);

		long long delay = 1000000;
		mytimer* timer = new mytimer(delay);
		timer->keep_timer(true);
		handle.set_timer(timer, delay);

		acl::aio_listen_stream* sstream = bind_addr(handle, addr);
		if (sstream) {
			printf(">>>begin run not use fiber mode\r\n");
			aio_run(use_reactor, std::ref(handle), sstream);
		}
	}

	return 0;
}
