#ifndef __LIB_ICMP_TYPE_INCLUDE_H__
#define __LIB_ICMP_TYPE_INCLUDE_H__

#define ICMP_TYPE_ECHOREPLY	0
#define ICMP_TYPE_ECHO		8

#define ICMP_CODE_EXTRA		16

typedef struct ICMP_STREAM ICMP_STREAM;
typedef struct ICMP_CHAT ICMP_CHAT;
typedef struct ICMP_STAT ICMP_STAT;
typedef struct ICMP_HOST ICMP_HOST;
typedef struct ICMP_PKT ICMP_PKT;
typedef struct ICMP_PKT_STATUS ICMP_PKT_STATUS;

/**< ICMP ͨŹÿ PING Ӧ״̬Ϣ */
struct ICMP_STAT {
	double tmin;			/**< ʱ */
	double tmax;			/**< ʱ */
	double tsum;			/**< ʱ */
	double tave;			/**< ƽʱ */
	size_t nsent;			/**< Ѿ͵İ */
	size_t nreceived;		/**< Ѿյİ */
	double loss;			/**< ʧİ */
};

#define ICMP_MIN_PACKET		32
#define ICMP_MAX_PACKET		1024

/**< ICMP ͵ÿ PING ֮״̬Ӧ */
struct ICMP_PKT_STATUS {
	size_t reply_len;		/**< ظݳ */
	char   from_ip[64];		/**< Դַ */

	double         rtt;		/**< ʱ()(Round Trip Time) */
	unsigned short seq;		/**< к(seq no) */
	unsigned char  ttl;		/**< ʱ(time to live) */
	unsigned int   gid;
	char          *data;
	size_t         dlen;
	char           status;
#define ICMP_STATUS_INIT		0
#define ICMP_STATUS_OK			1
#define ICMP_STATUS_UNREACH		(1<<1) 
#define ICMP_STATUS_TIMEOUT		(1<<2)

	ICMP_PKT      *pkt;
};

/**< ĿϢṹ */
struct ICMP_HOST {
	ICMP_STAT icmp_stat;		/**< ICMP ͨŹе״̬ */
	char dest_ip[32];		/**< ĿIPַ */
	char domain[64];		/**< ĿIPӦ */
	struct sockaddr_in dest;	/**< ͰʱĿַ */
	struct sockaddr_in from;	/**< ʱԴַ */
	int   from_len;			/**< ʱ洢 from еĵַ */
	int   delay;			/**<  PING ļλΪ */
	int   timeout;			/**< ʱʱ() */
	size_t dlen;			/**< ÿͰĴС(ֽ) */
	size_t nsent;			/**< Ѿ͸Ŀĸ */

	ICMP_PKT **pkts;		/**< а */
	size_t npkt;			/**< õĿͰĸ */
	size_t ipkt;			/**< ¼һҪ͵İ± */

	ACL_RING   host_ring;		/**<  ICMP_CHAT->host_head  */
	ICMP_CHAT *chat;		/**< ͨŶ */
	char  enable_log;		/**< ǷӦϢ־ */

	/**< 㱨ͰӦ״̬ */
	void (*stat_respond)(ICMP_PKT_STATUS*, void*);

	/**< ÷ͰӦʱ */
	void (*stat_timeout)(ICMP_PKT_STATUS*, void*);

	/**< ɴ */
	void (*stat_unreach)(ICMP_PKT_STATUS*, void*);

	/**< İʱĻص */
	void (*stat_finish)(ICMP_HOST*, void*);

	/**< Ӧôݵ˽вַ */
	void *arg;
};

#endif
