#ifndef	__SMTP_CLIENT_INCLUDE_H__
#define	__SMTP_CLIENT_INCLUDE_H__

/* #include "lib_acl.h" */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SMTP_LIB
# ifndef SMTP_API
#  define SMTP_API
# endif
#elif defined(SMTP_DLL) /* || defined(_WINDLL) */
# if defined(SMTP_EXPORTS) || defined(protocol_EXPORTS)
#  ifndef SMTP_API
#   define SMTP_API __declspec(dllexport)
#  endif
# elif !defined(SMTP_API)
#  define SMTP_API __declspec(dllimport)
# endif
#elif !defined(SMTP_API)
# define SMTP_API
#endif

typedef struct SMTP_CLIENT {
	ACL_VSTREAM *conn;
	int   smtp_code;
	char* buf;
	int   size;
	unsigned int flag;
#define SMTP_FLAG_PIPELINING	(1 << 0)
#define SMTP_FLAG_AUTH          (1 << 1)
#define SMTP_FLAG_8BITMIME      (1 << 2)
#define SMTP_FLAG_DSN           (1 << 3)
#define SMTP_FLAG_VRFY          (1 << 4)
#define SMTP_FLAG_ETRN          (1 << 5)
#define SMTP_FLAG_SIZE          (1 << 6)
	int   message_size_limit;
} SMTP_CLIENT;

/**
 * Զ SMTP 
 * @param addr {const char*} SMTP ַʽdomain:port
 * @param conn_timeout {int} ӳʱʱ
 * @param rw_timeout {int} IOдʱʱ
 * @param line_limit {int} SMTP Ựÿе󳤶
 * @return {SMTP_CLIENT*} ӳɹطǿֵ򷵻 NULL
 */
SMTP_API SMTP_CLIENT *smtp_open(const char *addr, int conn_timeout,
	int rw_timeout, int line_limit);

/**
 * ر smtp_open 򿪵 SMTP ӲͷŶ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 */
SMTP_API void smtp_close(SMTP_CLIENT *client);

/**
 *  SMTP ĻӭϢ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_get_banner(SMTP_CLIENT *client);

/**
 *  SMTP  HELO/EHLO 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param name {const char*} Ϣһ
 * @param ehlo {int}  0 ʱʹ EHLOʹ HELO
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */

SMTP_API int smtp_greet(SMTP_CLIENT *client, const char* name, int ehlo);

/**
 *  SMTP  HELO 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param helo {const char*} Ϣһ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_helo(SMTP_CLIENT *client, const char *helo);

/**
 *  SMTP  EHLO 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param ehlo {const char*} Ϣһ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_ehlo(SMTP_CLIENT *client, const char *ehlo);

/**
 *  SMTP ֤Ϣ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param user {const char*} SMTP ʼ˺
 * @param pass {const char*} SMTP ʼ˺
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_auth(SMTP_CLIENT *client, const char *user, const char *pass);

/**
 *  SMTP  MAIL FROM 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param from {const char*} 
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_mail(SMTP_CLIENT *client, const char *from);

/**
 *  SMTP  RCPT TO 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param to {const char*} 
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_rcpt(SMTP_CLIENT *client, const char *to);

/**
 *  SMTP  DATA 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_data(SMTP_CLIENT *client);

/**
 *  SMTP ʼݣѭñֱݷ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param src {const char*} ʼ MIME ʽʼ
 * @param len {size_t} src ݳ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_send(SMTP_CLIENT *client, const char* src, size_t len);

/**
 *  SMTP ʼݣѭñֱݷ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param fmt {const char*} ʽַ
 * @param ... 
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_printf(SMTP_CLIENT *client, const char* fmt, ...);

/**
 * ʼݺñ SMTP ʼ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_data_end(SMTP_CLIENT *client);

/**
 *  SMTP ָ·ʼļ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param filepath {const char*} ʼļ·
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_send_file(SMTP_CLIENT *client, const char *filepath);

/**
 *  SMTP ͸ļʼ
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @param in {ACL_VSTREAM*} ʼļ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_send_stream(SMTP_CLIENT *client, ACL_VSTREAM *in);

/**
 *  SMTP ˳(QUIT)
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_quit(SMTP_CLIENT *client);

/**
 *  SMTP  NOOP 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_noop(SMTP_CLIENT *client);

/**
 *  SMTP  RSET 
 * @param client {SMTP_CLIENT*} SMTP Ӷ
 * @return {int} 0 ʾɹ(SMTP_CLIENT::smtp_code ʾ룬
 *  SMTP_CLIENT::buf 洢Ӧ)ʾӦùرӶ
 */
SMTP_API int smtp_rset(SMTP_CLIENT *client);

#ifdef __cplusplus
}
#endif

#endif
