# 贡献指南

感谢您对 `Furion` 项目的关注和贡献！本指南将指导您如何有效参与到项目中来，共同构建更强大的开源框架。

## 错误报告

若您在 `Furion` 中发现了非安全相关的漏洞，请首先在 `Furion` 仓库的 [Issues](https://gitee.com/dotnetchina/Furion/issues) 中搜索以确认该问题尚未被提交。若未找到相似问题，请创建一个新的 Issue，并详尽描述漏洞详情、重现步骤及环境信息。

## 安全问题处理

对于安全问题的披露，请遵循以下流程：

1. **收集信息**：尽可能详细地记录漏洞的描述、影响范围、可能的攻击方法等信息。您可以在报告中提供相关的截图、日志文件等辅助信息。
2. **联系方式**：请您提供您的联系方式，以便我们与您进行进一步的沟通和反馈。您可以在报告中留下您的电子邮件地址、社交媒体账号或其他可靠的联系方式。
3. **发送报告**：请将您的安全漏洞报告发送至我们指定的安全邮箱 (monksoul@outlook.com) 或报告渠道（作者微信：ibaiqian）。如果我们有提供特定的报告指南或漏洞报告表格，请您按照指示进行报告。如果没有特定的指引，您可以通过邮件发送报告给我们的安全团队。
4. **等待回复**：我们将尽快收到您的报告后进行评估，并在确认漏洞的准确性后与您联系。请理解我们可能需要一些时间来进行调查和修复漏洞，我们会及时地与您保持沟通并提供进展更新。

## 解决现有问题

欢迎您浏览仓库的 [Issues](https://gitee.com/dotnetchina/Furion/issues) 列表，挑选并尝试解决其中的问题。一旦解决问题，请提交 Pull Request，并在描述中关联到原始的 Issue 编号。

## 提出新功能建议

我们鼓励通过 [Issues](https://gitee.com/dotnetchina/Furion/issues) 来提议新功能，并使用 "Feature/新特性" 标签标记。另外，也可以通过邮件（请参阅项目文档获取联系方式）向我们发送您的建议。项目团队会在评估后，将确认开发的新功能纳入下一个版本的计划任务列表。

## 开发环境搭建与测试运行

从 `git clone https://gitee.com/dotnetchina/Furion.git` 开始，参照我们的 [开发环境配置](./DEVELOPMENT_SETUP.md) 设置 IDE 和其他相关环境。运行测试时，请按照 [测试指南](./TESTING_GUIDE.md) 操作。

## 变更日志撰写规则

1. 使用现在时态描述变更。
2. 首行简洁扼要，字数适中。
3. 描述变更内容需准确、完整，符合项目的变更日志规范。

## 编码约定

遵循项目内的编码约定，具体见 [`.editorconfig`](https://gitee.com/dotnetchina/Furion/blob/v4/framework/.editorconfig) 文件。

## 分支管理约定

我们采用 [GitFlow](https://www.atlassian.com/git/tutorials/comparing-workflows/gitflow-workflow) 分支管理模式进行开发，详细规定见 [分支管理](./BRANCH_MANAGEMENT.md)。

## 合并 Pull Request 的流程

当满足以下条件时，您的 Pull Request 可以被合并至 `master/main` 分支：

1. 通过持续集成 (CI) 测试。
2. 至少获得两位维护者的批准。
3. 确保与最新版本兼容且无冲突。

**重要提示**：无论您是修复了 bug 还是改进了功能，我们都强烈建议您将更改同步回上游（即 `Furion` 主仓库）。请在完成工作后通过 Pull Request 或邮件通知我们，我们将迅速进行审核并考虑合并您的改动。

---

请尊重并遵守我们的 [行为准则](./CODE_OF_CONDUCT.md)，让我们共同营造一个友善、合作的开源社区氛围。感谢您的每一次贡献，若有任何疑问或需要协助，请随时联系我们。
