package breaker

const (
	success = iota
	fail
	drop
)

// bucket defines the bucket that holds sum and num of additions.
type bucket struct {
	Sum     int64
	Success int64
	Failure int64
	Drop    int64
}

func (b *bucket) Add(v int64) {
	switch v {
	case fail:
		b.fail()
	case drop:
		b.drop()
	default:
		b.succeed()
	}
}

func (b *bucket) Reset() {
	b.Sum = 0
	b.Success = 0
	b.Failure = 0
	b.Drop = 0
}

func (b *bucket) drop() {
	b.Sum++
	b.Drop++
}

func (b *bucket) fail() {
	b.Sum++
	b.Failure++
}

func (b *bucket) succeed() {
	b.Sum++
	b.Success++
}
