package migrationnotes

import (
	"fmt"
	"os"
	"strings"
)

func migrateBefore1_3_4(dir, style string) error {
	ok, err := needShow1_3_4(dir, style)
	if err != nil {
		return err
	}
	if !ok {
		return nil
	}

	fmt.Println(`It seems like that your goctl has just been upgraded to version 1.3.4 or later, which refactored the code of the model module. The original XXXmodel.go has been split into XXXmodel_gen.go (read-only) and XXXmodel.go. You just need to follow these steps to complete the migration:
1. back up the original XXXmodel.go (make sure the file name is no longer in the current directory)
2. re-run the generate command (a new XXXmodel.go will be created)
3. populate XXXmodel.go with the code that is not generated by goctl according to the comments in XXXmodel_gen.go`)

	return nil
}

func needShow1_3_4(dir, style string) (bool, error) {
	files, err := os.ReadDir(dir)
	if err != nil {
		return false, nil
	}
	// Returns false when the directory contains a file with the suffix "_gen.go"
	// In addition, it returns true if it contains a model file extension.
	// In other case, false is returned.
	for _, f := range files {
		if f.IsDir() {
			continue
		}
		if strings.HasSuffix(f.Name(), "_gen.go") {
			return false, nil
		}
	}
	modelSuffix, err := getModelSuffix(style)
	if err != nil {
		return false, err
	}
	for _, f := range files {
		if !f.IsDir() && strings.HasSuffix(f.Name(), modelSuffix) {
			return true, nil
		}
	}
	return false, nil
}
