package util

import "github.com/zeromicro/go-zero/tools/goctl/internal/version"

const (
	// DoNotEditHead added to the beginning of a file to prompt the user not to edit
	DoNotEditHead = "// Code generated by goctl. DO NOT EDIT."

	headTemplate = DoNotEditHead + `
// goctl {{.version}}
// Source: {{.source}}`
)

// GetHead returns a code head string with source filename
func GetHead(source string) string {
	buffer, _ := With("head").Parse(headTemplate).Execute(map[string]any{
		"source":  source,
		"version": version.BuildVersion,
	})
	return buffer.String()
}
