﻿using System.Collections.Generic;

namespace Sunny.UI
{
    internal class UILedChars
    {
        public static readonly Dictionary<char, byte[]> Chars = new Dictionary<char, byte[]>
        {
            [' '] = new byte[] { 0x00, 0x00, 0x00, 0x00, 0x00 },
            ['!'] = new byte[] { 0x00, 0x00, 0xFA, 0x00, 0x00 },
            ['\"'] = new byte[] { 0x00, 0xC0, 0x00, 0xC0, 0x00 },
            ['#'] = new byte[] { 0x28, 0x7C, 0x28, 0x7C, 0x28 },
            ['$'] = new byte[] { 0x24, 0x54, 0xFE, 0x54, 0x48 },
            ['%'] = new byte[] { 0x64, 0x68, 0x10, 0x2C, 0x4C },
            ['&'] = new byte[] { 0x6C, 0x92, 0xAA, 0x44, 0x0A },
            ['\''] = new byte[] { 0x00, 0x20, 0xC0, 0x00, 0x00 },
            ['('] = new byte[] { 0x00, 0x00, 0x7C, 0x82, 0x00 },
            [')'] = new byte[] { 0x00, 0x82, 0x7C, 0x00, 0x00 },
            ['*'] = new byte[] { 0x54, 0x38, 0xFE, 0x38, 0x54 },
            ['+'] = new byte[] { 0x10, 0x10, 0x7C, 0x10, 0x10 },
            [','] = new byte[] { 0x00, 0x02, 0x04, 0x00, 0x00 },
            ['-'] = new byte[] { 0x10, 0x10, 0x10, 0x10, 0x10 },
            ['.'] = new byte[] { 0x00, 0x00, 0x02, 0x00, 0x00 },
            ['/'] = new byte[] { 0x04, 0x08, 0x10, 0x20, 0x40 },
            ['0'] = new byte[] { 0x7C, 0x8A, 0x92, 0xA2, 0x7C },
            ['1'] = new byte[] { 0x00, 0x42, 0xFE, 0x02, 0x00 },
            ['2'] = new byte[] { 0x46, 0x8A, 0x92, 0x92, 0x62 },
            ['3'] = new byte[] { 0x44, 0x82, 0x92, 0x92, 0x6C },
            ['4'] = new byte[] { 0xF0, 0x10, 0x10, 0x10, 0xFE },
            ['5'] = new byte[] { 0xF4, 0x92, 0x92, 0x92, 0x8C },
            ['6'] = new byte[] { 0x7C, 0x92, 0x92, 0x92, 0x4C },
            ['7'] = new byte[] { 0xC0, 0x80, 0x8E, 0x90, 0xE0 },
            ['8'] = new byte[] { 0x6C, 0x92, 0x92, 0x92, 0x6C },
            ['9'] = new byte[] { 0x64, 0x92, 0x92, 0x92, 0x7C },
            [':'] = new byte[] { 0x00, 0x00, 0x24, 0x00, 0x00 },
            [';'] = new byte[] { 0x00, 0x02, 0x24, 0x00, 0x00 },
            ['<'] = new byte[] { 0x10, 0x28, 0x44, 0x82, 0x00 },
            ['='] = new byte[] { 0x28, 0x28, 0x28, 0x28, 0x28 },
            ['>'] = new byte[] { 0x00, 0x82, 0x44, 0x28, 0x10 },
            ['?'] = new byte[] { 0x40, 0x80, 0x9A, 0x90, 0x60 },
            ['@'] = new byte[] { 0x7C, 0x92, 0xAA, 0xBA, 0x70 },
            ['A'] = new byte[] { 0x7E, 0x90, 0x90, 0x90, 0x7E },
            ['B'] = new byte[] { 0xFE, 0x92, 0x92, 0x92, 0x6C },
            ['C'] = new byte[] { 0x7C, 0x82, 0x82, 0x82, 0x44 },
            ['D'] = new byte[] { 0xFE, 0x82, 0x82, 0x82, 0x7C },
            ['E'] = new byte[] { 0xFE, 0x92, 0x92, 0x92, 0x82 },
            ['F'] = new byte[] { 0xFE, 0x90, 0x90, 0x90, 0x80 },
            ['G'] = new byte[] { 0x7C, 0x82, 0x92, 0x92, 0x5C },
            ['H'] = new byte[] { 0xFE, 0x10, 0x10, 0x10, 0xFE },
            ['I'] = new byte[] { 0x82, 0x82, 0xFE, 0x82, 0x82 },
            ['J'] = new byte[] { 0x04, 0x02, 0x02, 0x02, 0xFC },
            ['K'] = new byte[] { 0xFE, 0x10, 0x28, 0x44, 0x82 },
            ['L'] = new byte[] { 0xFE, 0x02, 0x02, 0x02, 0x02 },
            ['M'] = new byte[] { 0xFE, 0x40, 0x20, 0x40, 0xFE },
            ['N'] = new byte[] { 0xFE, 0x20, 0x10, 0x08, 0xFE },
            ['O'] = new byte[] { 0x7C, 0x82, 0x82, 0x82, 0x7C },
            ['P'] = new byte[] { 0xFE, 0x90, 0x90, 0x90, 0x60 },
            ['Q'] = new byte[] { 0x7C, 0x82, 0x82, 0x86, 0x7E },
            ['R'] = new byte[] { 0xFE, 0x90, 0x90, 0x90, 0x6E },
            ['S'] = new byte[] { 0x64, 0x92, 0x92, 0x92, 0x4C },
            ['T'] = new byte[] { 0x80, 0x80, 0xFE, 0x80, 0x80 },
            ['U'] = new byte[] { 0xFC, 0x02, 0x02, 0x02, 0xFC },
            ['V'] = new byte[] { 0xE0, 0x18, 0x06, 0x18, 0xE0 },
            ['W'] = new byte[] { 0xFC, 0x02, 0x0C, 0x02, 0xFC },
            ['X'] = new byte[] { 0xC6, 0x28, 0x10, 0x28, 0xC6 },
            ['Y'] = new byte[] { 0xC0, 0x20, 0x1E, 0x20, 0xC0 },
            ['Z'] = new byte[] { 0x86, 0x8A, 0x92, 0xA2, 0xC2 },
            ['['] = new byte[] { 0x00, 0xFE, 0x82, 0x82, 0x00 },
            ['\\'] = new byte[] { 0x40, 0x20, 0x10, 0x08, 0x04 },
            [']'] = new byte[] { 0x00, 0x82, 0x82, 0xFE, 0x00 },
            ['^'] = new byte[] { 0x20, 0x40, 0x80, 0x40, 0x20 },
            ['_'] = new byte[] { 0x02, 0x02, 0x02, 0x02, 0x02 },
            ['`'] = new byte[] { 0x00, 0x00, 0xC0, 0x20, 0x00 },
            ['°'] = new byte[] { 0x00, 0x00, 0x40, 0xA0, 0x40 },
            ['a'] = new byte[] { 0x04, 0x2A, 0x2A, 0x2A, 0x1E },
            ['b'] = new byte[] { 0xFE, 0x22, 0x22, 0x22, 0x1C },
            ['c'] = new byte[] { 0x1C, 0x22, 0x22, 0x22, 0x14 },
            ['d'] = new byte[] { 0x1C, 0x22, 0x22, 0x22, 0xFE },
            ['e'] = new byte[] { 0x1C, 0x2A, 0x2A, 0x2A, 0x18 },
            ['f'] = new byte[] { 0x10, 0x7E, 0x90, 0x90, 0x40 },
            ['g'] = new byte[] { 0x10, 0x2A, 0x2A, 0x2A, 0x1C },
            ['h'] = new byte[] { 0xFE, 0x20, 0x20, 0x20, 0x1E },
            ['i'] = new byte[] { 0x00, 0x22, 0xBE, 0x02, 0x00 },
            ['j'] = new byte[] { 0x00, 0x02, 0xBC, 0x00, 0x00 },
            ['k'] = new byte[] { 0xFE, 0x08, 0x08, 0x14, 0x22 },
            ['l'] = new byte[] { 0x00, 0x82, 0xFE, 0x02, 0x00 },
            ['m'] = new byte[] { 0x3E, 0x20, 0x3E, 0x20, 0x1E },
            ['n'] = new byte[] { 0x3E, 0x20, 0x20, 0x20, 0x1E },
            ['o'] = new byte[] { 0x1C, 0x22, 0x22, 0x22, 0x1C },
            ['p'] = new byte[] { 0x3E, 0x28, 0x28, 0x28, 0x10 },
            ['q'] = new byte[] { 0x10, 0x28, 0x28, 0x28, 0x3E },
            ['r'] = new byte[] { 0x3E, 0x20, 0x20, 0x20, 0x10 },
            ['s'] = new byte[] { 0x12, 0x2A, 0x2A, 0x2A, 0x24 },
            ['t'] = new byte[] { 0x20, 0xFC, 0x22, 0x22, 0x00 },
            ['u'] = new byte[] { 0x3C, 0x02, 0x02, 0x02, 0x3E },
            ['v'] = new byte[] { 0x38, 0x04, 0x02, 0x04, 0x38 },
            ['w'] = new byte[] { 0x3C, 0x02, 0x0C, 0x02, 0x3C },
            ['x'] = new byte[] { 0x22, 0x14, 0x08, 0x14, 0x22 },
            ['y'] = new byte[] { 0x22, 0x14, 0x08, 0x10, 0x20 },
            ['z'] = new byte[] { 0x22, 0x26, 0x2A, 0x32, 0x22 },
            ['{'] = new byte[] { 0x00, 0x10, 0x6C, 0x82, 0x00 },
            ['|'] = new byte[] { 0x00, 0x00, 0xFE, 0x00, 0x00 },
            ['}'] = new byte[] { 0x00, 0x82, 0x6C, 0x10, 0x00 },
            ['~'] = new byte[] { 0x40, 0x80, 0x40, 0x20, 0x40 },
            ['Κ'] = new byte[] { 0xFE, 0x10, 0x28, 0x44, 0x82 },
            ['Χ'] = new byte[] { 0xC6, 0x28, 0x10, 0x28, 0xC6 },
            ['Υ'] = new byte[] { 0xC0, 0x20, 0x1E, 0x20, 0xC0 },
            ['Μ'] = new byte[] { 0xFE, 0x40, 0x20, 0x40, 0xFE },
            ['Γ'] = new byte[] { 0xFE, 0x80, 0x80, 0x80, 0x80 },
            ['Ν'] = new byte[] { 0xFE, 0x20, 0x10, 0x08, 0xFE },
            ['Ξ'] = new byte[] { 0x82, 0x92, 0x92, 0x92, 0x82 },
            ['Ο'] = new byte[] { 0x7C, 0x82, 0x82, 0x82, 0x7C },
            ['Θ'] = new byte[] { 0x7C, 0x92, 0x92, 0x92, 0x7C },
            ['Π'] = new byte[] { 0xFE, 0x80, 0x80, 0x80, 0xFE },
            ['Ρ'] = new byte[] { 0xFE, 0x90, 0x90, 0x90, 0x60 },
            ['Ω'] = new byte[] { 0x7A, 0x8E, 0x80, 0x8E, 0x7A },
            ['Ψ'] = new byte[] { 0xF0, 0x08, 0xFE, 0x08, 0xF0 },
            ['Ι'] = new byte[] { 0x82, 0x82, 0xFE, 0x82, 0x82 },
            ['∞'] = new byte[] { 0x38, 0x44, 0x38, 0x44, 0x38 },
            ['Α'] = new byte[] { 0x7E, 0x90, 0x90, 0x90, 0x7E },
            ['Δ'] = new byte[] { 0x0E, 0x32, 0xC2, 0x32, 0x0E },
            ['Λ'] = new byte[] { 0x0E, 0x30, 0xC0, 0x30, 0x0E },
            ['Ε'] = new byte[] { 0xFE, 0x92, 0x92, 0x92, 0x82 },
            ['Η'] = new byte[] { 0xFE, 0x10, 0x10, 0x10, 0xFE },
            ['Φ'] = new byte[] { 0x38, 0x44, 0xFE, 0x44, 0x38 },
            ['Β'] = new byte[] { 0xFE, 0x92, 0x92, 0x92, 0x6C },
            ['Τ'] = new byte[] { 0x80, 0x80, 0xFE, 0x80, 0x80 },
            ['Ζ'] = new byte[] { 0x86, 0x8A, 0x92, 0xA2, 0xC2 },
            ['Σ'] = new byte[] { 0xC6, 0xAA, 0x92, 0x82, 0x82 },
            ['：'] = new byte[] { 0x00, 0x00, 0x24, 0x00, 0x00 },
        };

        /// <summary>
        /// 增加LED字符
        /// </summary>
        /// <param name="key">字符</param>
        /// <param name="bytes">显示</param>
        public static void Add(char key, byte[] bytes)
        {
            if (!Chars.ContainsKey(key))
            {
                Chars.Add(key, bytes);
            }
        }
    }
}
