# Changelog for Highcharts Dashboards v2.0.0 (2024-03-13)

- Added support for [custom HTML layout](https://www.highcharts.com/docs/dashboards/layout-description#custom-layout). The use of `gui` is now optional.
- Dashboard, and charts, are now [100% stylable via CSS](https://www.highcharts.com/docs/dashboards/style-by-css) instead of JavaScript configuration.
- Include what you need, with [Dashboards Core](https://www.highcharts.com/docs/dashboards/installation), [Layout/EditMode](https://www.highcharts.com/docs/dashboards/layout-description) and [DataGrid](https://www.highcharts.com/docs/dashboards/datagrid-component) as separate scripts. `dashboards-plugin` is removed and no longer needed.
- Improved [chart synchronization options](https://www.highcharts.com/docs/dashboards/synchronize-components), and added additional options to highlight synchronization. `highlight`, `tooltip` and `crosshair` can now be set separately.
- Improved and simplified [column assignment](https://www.highcharts.com/docs/dashboards/highcharts-component#working-with-data). Moved the option from `component` scope to `component.connector`.
- Added support for HTML as string in the [HTML Component](https://www.highcharts.com/docs/dashboards/html-component).

## Upgrade notes

- [Dashboards Core](https://www.highcharts.com/docs/dashboards/installation), [Layout/EditMode](https://www.highcharts.com/docs/dashboards/layout-description) and [DataGrid](https://www.highcharts.com/docs/dashboards/datagrid-component) are now seperate scripts, and needs to be explicitly included whenever needed. See respective documentation articles for details.
- The old `columnAssignment` logic is no longer supported, and needs to be refactored to [the new one](https://www.highcharts.com/docs/dashboards/highcharts-component#working-with-data).
- Responsive layout should now be specified using [CSS media queries](https://www.highcharts.com/docs/dashboards/layout-description#how-the-dashboard-layout-engine-makes-your-dashboard-responsive).

## Bug fixes

- Fixed synchronization was not stopping during component destroy.
- Fixed point dragging with `allowConnectorUpdate` in Highcharts Component.
