# Changelog for Highcharts Dashboards v2.2.0 (2024-07-02)

- Added the `EditMode` for dashboards declared with custom HTML, allowing users to modify the components inside.
- Added the methods `getComponentById `and `getComponentByCellId` to the `Board` class. Addressing feature request [#21378](https://github.com/highcharts/highcharts/issues/21378).
- Renamed `onEditModeToggle` to `toggleEditMode`.
- Removed the setting icon from the row toolbar.
- Added [edit mode events](https://www.highcharts.com/docs/dashboards/edit-mode#edit-mode-events). Changed the way components are updated in edit mode. See [#20756](https://github.com/highcharts/highcharts/issues/20756).
- Added `isStandalone` option to add non-nested options in the edit mode sidebar, [#20793](https://github.com/highcharts/highcharts/issues/20793).
- Improved error messages when options were misconfigured, see [#21091](https://github.com/highcharts/highcharts/issues/21091).
- Added option to use valid HTML inside the DataGrid cell, along with that the `useHTML` option was added, see [#20634](https://github.com/highcharts/highcharts/issues/20634).
- Added `autoScroll` option to the Datagrid's highlight sync.
- Added the [`group`](https://api.highcharts.com/dashboards/#interfaces/Dashboards_Components_Sync_Sync.Sync.OptionsEntry#group) option which allows synchronization to be grouped within components sharing the same connector.

## Bug fixes
- Fixed [#21310](https://github.com/highcharts/highcharts/issues/21310), updating values in the DataGrid did not update connected components.
- Fixed [#21189](https://github.com/highcharts/highcharts/issues/21189), dragging and dropping elements from the sidebar and inside the dashboard was impossible in Firefox.
- Removed connector name from the HTML component sidebar.
- Fixed typo in `Fullscreen` es-module import which caused an error when importing the `layout` module.
- Fixed [#21079](https://github.com/highcharts/highcharts/issues/21079), `false` was displayed in the input inside the sidebar when the option was disabled.
- Fixed [#20944](https://github.com/highcharts/highcharts/issues/20944), wrong values were displayed in the sidebar when the Highcharts component was initialized with programmatically set options.
