# Changelog for Highstock v1.1.6 ()
        
- Removed double clipping assignment in development branch, and subsequent JS error on Series.remove in legacy IE. #1027.
- Added tooltip formatting options: percentageDecimals, percentagePrefix, percentageSuffix, totalDecimals, totalPrefix, totalSuffix. #864.
- Worked around compatibility issue with jQuery 1.8 preview.
- Made the tooltip follow the mouse position for shared tooltips with more than 1 series. This fixes problems with the tooltip being rendered close to the top series (or alternatively in another computed middle position) when the user is actually hovering another series. #424.
- Added scrolling for the legend. Added legend.navigation options set.
- Removed warnings on accessing layerX and layerY in Chrome.
- Worked around issue with overlapping shadows on stacked columns. Shadow elements are now cut off.
- Added time-aware xDateFormat for tooltip headers in datetime axes. Added tooltip.dateTimeLabelFormat option. #568.
- Updated fix for #608 to work around JS error in Firefox.
- Prevented trying to set extremes on empty axes when using selection zoom. #859. #906.
- Don't create multiple title nodes on subsequently setting attr title. #891.
- Worked around issue with tooltips for stacked bar chart were not visible in IE7. #863.
- Added smooth animation when adding multiple points. #860.
- Changed zIndex on the range selector buttons in order for the tooltip to show above them. #852.
- Prevented error on exporting in Prototype by setting default border radius for data labels to 0. #853.
- Adding enctype to the exporting post to allow it to work in HTTPS in Firefox. #839.
- Set xAxis.labels.overflow option to null by default in Highcharts, while 'justify' in Stock charts only. #841.
- Allow the tooltip and the point hover state to survive a chart redraw. #349.
- Worked on data labels for range series.

## Bug fixes
- Fixed issue with legend text not wrapping correctly to itemStyle.width option ion IE8. #1021.
- Fixed issues with grouped data points not being destroyed after zooming on Y axis only. #622.
- Fixed error message in Firefox when using jQuery UI datepicker against range selector inputs. #1020.
- Fixed stuck tooltip, crosshairs and state marker after zooming in Highstock. #1003.
- Fixed JS errors in Highstock when trying to pan a chart with no series. #1017.
- Fixed JS error on quickly changing range selection in Highstock in column charts. #1004.
- Fixed issue with size detection of rotated text in exported charts legacy IE. #997.
- Fixed issue with original mouse event information not being passed over to legendItemClick handler. Added it to event.browserEvent. #4. #992.
- Fixed issue with error #10 appearing on a chart with all null data if yAxis.min was set.
- Fixed issue when colorByPoint was set to true, it started from the second item in the color array, whereas the first one was assigned to the whole series. #974.
- Fixed JS error on setting categories with fewer items before the chart was redrawn. #970.
- Fixed bug that removed all win.resize handlers. #982.
- Fixed issue with X axis labels becoming left aligned instead of centered in IE8 on an axis with many labels. #983.
- Fixed problem with unwanted chart border when printing in Chrome. #980.
- Fixed issue in protofy branch that choked on setting extremes in Highstock.
- Fixed issue with black background in data labels in legacy IE and MooTools adapter. #947.
- Fixed excessive looping in setTooltipPoints in certain conditions involving hidden series. #945.
- Fixed issue with stack columns' position after redrawing chart. #936.
- Fixed issue where a line with lineWidth of 0 wouldn't show in hover mode. #940.
- Fixed issue with lang.decimalPoint option not being applied to axis labels. #939.
- Fixed float rounding error that caused extra tick position on logarithmic Y axes. #934.
- Fixed issue with alignTicks not being respected after a chart redraw. #842.
- Fixed JS error when adding points to a series before redraw. #927.
- Fixed JS error message on running Axis.setTitle before axis is first rendered. #922.
- Fixed NaN in attributes in export in Firefox 3.5. #912.
- Fixed test size detection bug in bar charts with line-broken labels. #909. #882.
- Fixed issues with setData for pies. #542.
- Fixed error message on setSize without navigator in Highstock. #904.
- Fixed Highstock error on accessing Navigator series.
- Fixed unresponsive browser in IE8 Standards when exporting pie charts with data labels. #968.
- Fixed issue with scrollbar without navigator didn't respond to Chart.setSize. Partial fix for #955.
- Fixed issue with xAxis label formats not landing on whole days when using local time. #950.
- Fixed issue with tooltips not displaying over pie charts positioned outside plot area. #68. #956.
- Fixed errors and crashes on resize. #905.
- Fixed so stack totals are updated after point.update. #787.
- Fixed issue with position of stack total labels. #506 and #516.
- Fixed error on forced grouped series with no data. #885.
- Fixed problem with test size detection when rendering a chart within a container with an inherited display property. #883.
- Fixed problem with chart.click events firing after selection. #370.
- Fixed issue with wrong tooltip to point binding on bar charts containing null values. #833.
- Fixed problem with flags visible at the end of graph when zoomed off screen. #847.
- Fixed problem with range selector buttons not becoming unselected when clicking a new button. This happened only when the actual range wasn't changed because the buttons spanned a too wide range. #851.