# Changelog for Highstock v7.1.3 (2019-08-14)

- Most changes listed under Highcharts 7.1.3 above also apply to Highstock 7.1.3.
- Added new technical indicator, `trendline`, showing price trend.

## Bug fixes
- Fixed #11483, lastPrice indicator was incorrect with dataGrouping.
- Fixed #11415, vertical scrollbar was visible in annotation popup.
- Fixed #11175, [navigation.bindings.rectangleAnnotation](https://api.highcharts.com/highstock/navigation.bindings.rectangleAnnotation) did not resize it's width/height according to xAxis/yAxis extremes.
- Fixed #11174, size of measure annotation was not recalculated in redraw.
- Fixed #10980, defining just one item in `stockTools.gui.definitions[name]` threw errors.
- Fixed #11191, `dataGrouping.approximation.average` did not correct floating point precision errors.
- Fixed #10745, sometimes old points were not removed after updating data with enabled `dataGrouping`.
- Fixed #11366, `annotationOptions` did not work for some of the `bindings[annotationName]`.
- Fixed #11351, `gapSize` and multiple `dataGrouping`s sometimes hide series line with lower granularity.
- Fixed #11344, some icons were not loaded from custom url. Added new general option, [navigation.iconsURL](https://api.highcharts.com/highstock/navigation.iconsURL) that takes over from the more specific `stockTools.gui.iconsURL`.
- Fixed #11206, editing technical indicators in stock tools did not select correct series.
- Fixed #11079, stock-tools were not working correctly in inverted charts.
- Fixed #11005, X axis line width affected clipping of the series graph or columns, even when the Y axis did not extend to the X axis.
- Fixed #10827, issues with the TEMA indicator's tooltip and boost module. Caused by a method name collision.
- Fixed #10932, [xAxis.minPadding](https://api.highcharts.com/highstock/xAxis.minPadding) didn't work when [plotOptions.series.dataGrouping](https://api.highcharts.com/highstock/plotOptions.series.dataGrouping) was enabled.
